@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * This activity executes inner activities until the specified boolean expression results to true or timeout is reached, whichever is earlier.
 * @property activities List of activities to execute.
 * @property dependsOn Activity depends on condition.
 * @property description Activity description.
 * @property expression An expression that would evaluate to Boolean. The loop will continue until this expression evaluates to true
 * @property name Activity name.
 * @property onInactiveMarkAs Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
 * @property state Activity state. This is an optional property and if not provided, the state will be Active by default.
 * @property timeout Specifies the timeout for the activity to run. If there is no value specified, it takes the value of TimeSpan.FromDays(7) which is 1 week as default. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
 * @property type Type of activity.
 * Expected value is 'Until'.
 * @property userProperties Activity user properties.
 */
public data class UntilActivityResponse(
    public val activities: List<Any>,
    public val dependsOn: List<ActivityDependencyResponse>? = null,
    public val description: String? = null,
    public val expression: ExpressionResponse,
    public val name: String,
    public val onInactiveMarkAs: String? = null,
    public val state: String? = null,
    public val timeout: Any? = null,
    public val type: String,
    public val userProperties: List<UserPropertyResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.UntilActivityResponse): UntilActivityResponse = UntilActivityResponse(
            activities = javaType.activities().map({ args0 -> args0 }),
            dependsOn = javaType.dependsOn().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.ActivityDependencyResponse.Companion.toKotlin(args0)
                })
            }),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            expression = javaType.expression().let({ args0 ->
                com.pulumi.azurenative.datafactory.kotlin.outputs.ExpressionResponse.Companion.toKotlin(args0)
            }),
            name = javaType.name(),
            onInactiveMarkAs = javaType.onInactiveMarkAs().map({ args0 -> args0 }).orElse(null),
            state = javaType.state().map({ args0 -> args0 }).orElse(null),
            timeout = javaType.timeout().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            userProperties = javaType.userProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.UserPropertyResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
