@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import com.pulumi.core.Either
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Microsoft Fabric Warehouse linked service.
 * @property annotations List of tags that can be used for describing the linked service.
 * @property artifactId The ID of Microsoft Fabric Warehouse artifact. Type: string (or Expression with resultType string).
 * @property connectVia The integration runtime reference.
 * @property description Linked service description.
 * @property encryptedCredential The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
 * @property endpoint The endpoint of Microsoft Fabric Warehouse server. Type: string (or Expression with resultType string).
 * @property parameters Parameters for linked service.
 * @property servicePrincipalCredential The credential of the service principal object in Azure Active Directory. If servicePrincipalCredentialType is 'ServicePrincipalKey', servicePrincipalCredential can be SecureString or AzureKeyVaultSecretReference. If servicePrincipalCredentialType is 'ServicePrincipalCert', servicePrincipalCredential can only be AzureKeyVaultSecretReference.
 * @property servicePrincipalCredentialType The service principal credential type to use in Server-To-Server authentication. 'ServicePrincipalKey' for key/secret, 'ServicePrincipalCert' for certificate. Type: string (or Expression with resultType string).
 * @property servicePrincipalId The ID of the application used to authenticate against Microsoft Fabric Warehouse. Type: string (or Expression with resultType string).
 * @property servicePrincipalKey The Key of the application used to authenticate against Microsoft Fabric Warehouse.
 * @property tenant The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string).
 * @property type Type of linked service.
 * Expected value is 'Warehouse'.
 * @property workspaceId The ID of Microsoft Fabric workspace. Type: string (or Expression with resultType string).
 */
public data class WarehouseLinkedServiceResponse(
    public val annotations: List<Any>? = null,
    public val artifactId: Any,
    public val connectVia: IntegrationRuntimeReferenceResponse? = null,
    public val description: String? = null,
    public val encryptedCredential: String? = null,
    public val endpoint: Any,
    public val parameters: Map<String, ParameterSpecificationResponse>? = null,
    public val servicePrincipalCredential: Either<AzureKeyVaultSecretReferenceResponse, SecureStringResponse>? = null,
    public val servicePrincipalCredentialType: Any? = null,
    public val servicePrincipalId: Any? = null,
    public val servicePrincipalKey: Either<AzureKeyVaultSecretReferenceResponse, SecureStringResponse>? = null,
    public val tenant: Any? = null,
    public val type: String,
    public val workspaceId: Any? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.WarehouseLinkedServiceResponse): WarehouseLinkedServiceResponse = WarehouseLinkedServiceResponse(
            annotations = javaType.annotations().map({ args0 -> args0 }),
            artifactId = javaType.artifactId(),
            connectVia = javaType.connectVia().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.IntegrationRuntimeReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            encryptedCredential = javaType.encryptedCredential().map({ args0 -> args0 }).orElse(null),
            endpoint = javaType.endpoint(),
            parameters = javaType.parameters().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.datafactory.kotlin.outputs.ParameterSpecificationResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            servicePrincipalCredential = javaType.servicePrincipalCredential().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.AzureKeyVaultSecretReferenceResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.SecureStringResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null),
            servicePrincipalCredentialType = javaType.servicePrincipalCredentialType().map({ args0 ->
                args0
            }).orElse(null),
            servicePrincipalId = javaType.servicePrincipalId().map({ args0 -> args0 }).orElse(null),
            servicePrincipalKey = javaType.servicePrincipalKey().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.AzureKeyVaultSecretReferenceResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.SecureStringResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null),
            tenant = javaType.tenant().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            workspaceId = javaType.workspaceId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
