@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import com.pulumi.core.Either
import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * Web activity authentication properties.
 * @property credential The credential reference containing authentication information.
 * @property password Password for the PFX file or basic authentication / Secret when used for ServicePrincipal
 * @property pfx Base64-encoded contents of a PFX file or Certificate when used for ServicePrincipal
 * @property resource Resource for which Azure Auth token will be requested when using MSI Authentication. Type: string (or Expression with resultType string).
 * @property type Web activity authentication (Basic/ClientCertificate/MSI/ServicePrincipal)
 * @property userTenant TenantId for which Azure Auth token will be requested when using ServicePrincipal Authentication. Type: string (or Expression with resultType string).
 * @property username Web activity authentication user name for basic authentication or ClientID when used for ServicePrincipal. Type: string (or Expression with resultType string).
 */
public data class WebActivityAuthenticationResponse(
    public val credential: CredentialReferenceResponse? = null,
    public val password: Either<AzureKeyVaultSecretReferenceResponse, SecureStringResponse>? = null,
    public val pfx: Either<AzureKeyVaultSecretReferenceResponse, SecureStringResponse>? = null,
    public val resource: Any? = null,
    public val type: String? = null,
    public val userTenant: Any? = null,
    public val username: Any? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.WebActivityAuthenticationResponse): WebActivityAuthenticationResponse = WebActivityAuthenticationResponse(
            credential = javaType.credential().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.CredentialReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            password = javaType.password().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.AzureKeyVaultSecretReferenceResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.SecureStringResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null),
            pfx = javaType.pfx().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.AzureKeyVaultSecretReferenceResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.SecureStringResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null),
            resource = javaType.resource().map({ args0 -> args0 }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
            userTenant = javaType.userTenant().map({ args0 -> args0 }).orElse(null),
            username = javaType.username().map({ args0 -> args0 }).orElse(null),
        )
    }
}
