@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import com.pulumi.core.Either
import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * A WebLinkedService that uses basic authentication to communicate with an HTTP endpoint.
 * @property authenticationType Type of authentication used to connect to the web table source.
 * Expected value is 'Basic'.
 * @property password The password for Basic authentication.
 * @property url The URL of the web service endpoint, e.g. https://www.microsoft.com . Type: string (or Expression with resultType string).
 * @property username User name for Basic authentication. Type: string (or Expression with resultType string).
 */
public data class WebBasicAuthenticationResponse(
    public val authenticationType: String,
    public val password: Either<AzureKeyVaultSecretReferenceResponse, SecureStringResponse>,
    public val url: Any,
    public val username: Any,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.WebBasicAuthenticationResponse): WebBasicAuthenticationResponse = WebBasicAuthenticationResponse(
            authenticationType = javaType.authenticationType(),
            password = javaType.password().transform(
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.datafactory.kotlin.outputs.AzureKeyVaultSecretReferenceResponse.Companion.toKotlin(args0)
                    })
                },
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.datafactory.kotlin.outputs.SecureStringResponse.Companion.toKotlin(args0)
                    })
                },
            ),
            url = javaType.url(),
            username = javaType.username(),
        )
    }
}
