@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * WebHook activity.
 * @property authentication Authentication method used for calling the endpoint.
 * @property body Represents the payload that will be sent to the endpoint. Required for POST/PUT method, not allowed for GET method Type: string (or Expression with resultType string).
 * @property dependsOn Activity depends on condition.
 * @property description Activity description.
 * @property headers Represents the headers that will be sent to the request. For example, to set the language and type on a request: "headers" : { "Accept-Language": "en-us", "Content-Type": "application/json" }. Type: string (or Expression with resultType string).
 * @property method Rest API method for target endpoint.
 * @property name Activity name.
 * @property onInactiveMarkAs Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
 * @property policy Activity policy.
 * @property reportStatusOnCallBack When set to true, statusCode, output and error in callback request body will be consumed by activity. The activity can be marked as failed by setting statusCode >= 400 in callback request. Default is false. Type: boolean (or Expression with resultType boolean).
 * @property state Activity state. This is an optional property and if not provided, the state will be Active by default.
 * @property timeout The timeout within which the webhook should be called back. If there is no value specified, it defaults to 10 minutes. Type: string. Pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
 * @property type Type of activity.
 * Expected value is 'WebHook'.
 * @property url WebHook activity target endpoint and path. Type: string (or Expression with resultType string).
 * @property userProperties Activity user properties.
 */
public data class WebHookActivityResponse(
    public val authentication: WebActivityAuthenticationResponse? = null,
    public val body: Any? = null,
    public val dependsOn: List<ActivityDependencyResponse>? = null,
    public val description: String? = null,
    public val headers: Map<String, Any>? = null,
    public val method: String,
    public val name: String,
    public val onInactiveMarkAs: String? = null,
    public val policy: SecureInputOutputPolicyResponse? = null,
    public val reportStatusOnCallBack: Any? = null,
    public val state: String? = null,
    public val timeout: String? = null,
    public val type: String,
    public val url: Any,
    public val userProperties: List<UserPropertyResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.WebHookActivityResponse): WebHookActivityResponse = WebHookActivityResponse(
            authentication = javaType.authentication().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.WebActivityAuthenticationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            body = javaType.body().map({ args0 -> args0 }).orElse(null),
            dependsOn = javaType.dependsOn().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.ActivityDependencyResponse.Companion.toKotlin(args0)
                })
            }),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            headers = javaType.headers().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            method = javaType.method(),
            name = javaType.name(),
            onInactiveMarkAs = javaType.onInactiveMarkAs().map({ args0 -> args0 }).orElse(null),
            policy = javaType.policy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.SecureInputOutputPolicyResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            reportStatusOnCallBack = javaType.reportStatusOnCallBack().map({ args0 -> args0 }).orElse(null),
            state = javaType.state().map({ args0 -> args0 }).orElse(null),
            timeout = javaType.timeout().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            url = javaType.url(),
            userProperties = javaType.userProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.UserPropertyResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
