@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Power Query data flow.
 * @property annotations List of tags that can be used for describing the data flow.
 * @property description The description of the data flow.
 * @property documentLocale Locale of the Power query mashup document.
 * @property folder The folder that this data flow is in. If not specified, Data flow will appear at the root level.
 * @property script Power query mashup script.
 * @property sources List of sources in Power Query.
 * @property type Type of data flow.
 * Expected value is 'WranglingDataFlow'.
 */
public data class WranglingDataFlowResponse(
    public val annotations: List<Any>? = null,
    public val description: String? = null,
    public val documentLocale: String? = null,
    public val folder: DataFlowResponseFolder? = null,
    public val script: String? = null,
    public val sources: List<PowerQuerySourceResponse>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.WranglingDataFlowResponse): WranglingDataFlowResponse = WranglingDataFlowResponse(
            annotations = javaType.annotations().map({ args0 -> args0 }),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            documentLocale = javaType.documentLocale().map({ args0 -> args0 }).orElse(null),
            folder = javaType.folder().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.DataFlowResponseFolder.Companion.toKotlin(args0)
                })
            }).orElse(null),
            script = javaType.script().map({ args0 -> args0 }).orElse(null),
            sources = javaType.sources().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.PowerQuerySourceResponse.Companion.toKotlin(args0)
                })
            }),
            type = javaType.type(),
        )
    }
}
