@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datalakeanalytics.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ComputePolicy].
 */
@PulumiTagMarker
public class ComputePolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ComputePolicyArgs = ComputePolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ComputePolicyArgsBuilder.() -> Unit) {
        val builder = ComputePolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ComputePolicy {
        val builtJavaResource =
            com.pulumi.azurenative.datalakeanalytics.ComputePolicy(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ComputePolicy(builtJavaResource)
    }
}

/**
 * Data Lake Analytics compute policy information.
 * Azure REST API version: 2019-11-01-preview. Prior API version in Azure Native 1.x: 2016-11-01.
 * ## Example Usage
 * ### Creates or updates the specified compute policy
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var computePolicy = new AzureNative.DataLakeAnalytics.ComputePolicy("computePolicy", new()
 *     {
 *         AccountName = "contosoadla",
 *         ComputePolicyName = "test_policy",
 *         MaxDegreeOfParallelismPerJob = 10,
 *         MinPriorityPerJob = 30,
 *         ObjectId = "776b9091-8916-4638-87f7-9c989a38da98",
 *         ObjectType = AzureNative.DataLakeAnalytics.AADObjectType.User,
 *         ResourceGroupName = "contosorg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datalakeanalytics/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datalakeanalytics.NewComputePolicy(ctx, "computePolicy", &datalakeanalytics.ComputePolicyArgs{
 * 			AccountName:                  pulumi.String("contosoadla"),
 * 			ComputePolicyName:            pulumi.String("test_policy"),
 * 			MaxDegreeOfParallelismPerJob: pulumi.Int(10),
 * 			MinPriorityPerJob:            pulumi.Int(30),
 * 			ObjectId:                     pulumi.String("776b9091-8916-4638-87f7-9c989a38da98"),
 * 			ObjectType:                   pulumi.String(datalakeanalytics.AADObjectTypeUser),
 * 			ResourceGroupName:            pulumi.String("contosorg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datalakeanalytics.ComputePolicy;
 * import com.pulumi.azurenative.datalakeanalytics.ComputePolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var computePolicy = new ComputePolicy("computePolicy", ComputePolicyArgs.builder()
 *             .accountName("contosoadla")
 *             .computePolicyName("test_policy")
 *             .maxDegreeOfParallelismPerJob(10)
 *             .minPriorityPerJob(30)
 *             .objectId("776b9091-8916-4638-87f7-9c989a38da98")
 *             .objectType("User")
 *             .resourceGroupName("contosorg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:datalakeanalytics:ComputePolicy test_policy /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts/{accountName}/computePolicies/{computePolicyName}
 * ```
 */
public class ComputePolicy internal constructor(
    override val javaResource: com.pulumi.azurenative.datalakeanalytics.ComputePolicy,
) : KotlinCustomResource(javaResource, ComputePolicyMapper) {
    /**
     * The maximum degree of parallelism per job this user can use to submit jobs.
     */
    public val maxDegreeOfParallelismPerJob: Output<Int>
        get() = javaResource.maxDegreeOfParallelismPerJob().applyValue({ args0 -> args0 })

    /**
     * The minimum priority per job this user can use to submit jobs.
     */
    public val minPriorityPerJob: Output<Int>
        get() = javaResource.minPriorityPerJob().applyValue({ args0 -> args0 })

    /**
     * The resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The AAD object identifier for the entity to create a policy for.
     */
    public val objectId: Output<String>
        get() = javaResource.objectId().applyValue({ args0 -> args0 })

    /**
     * The type of AAD object the object identifier refers to.
     */
    public val objectType: Output<String>
        get() = javaResource.objectType().applyValue({ args0 -> args0 })

    /**
     * The resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ComputePolicyMapper : ResourceMapper<ComputePolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.datalakeanalytics.ComputePolicy::class == javaResource::class

    override fun map(javaResource: Resource): ComputePolicy = ComputePolicy(
        javaResource as
            com.pulumi.azurenative.datalakeanalytics.ComputePolicy,
    )
}

/**
 * @see [ComputePolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ComputePolicy].
 */
public suspend fun computePolicy(
    name: String,
    block: suspend ComputePolicyResourceBuilder.() -> Unit,
): ComputePolicy {
    val builder = ComputePolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ComputePolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun computePolicy(name: String): ComputePolicy {
    val builder = ComputePolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
