@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datalakeanalytics.kotlin

import com.pulumi.azurenative.datalakeanalytics.ComputePolicyArgs.builder
import com.pulumi.azurenative.datalakeanalytics.kotlin.enums.AADObjectType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Data Lake Analytics compute policy information.
 * Azure REST API version: 2019-11-01-preview. Prior API version in Azure Native 1.x: 2016-11-01.
 * ## Example Usage
 * ### Creates or updates the specified compute policy
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var computePolicy = new AzureNative.DataLakeAnalytics.ComputePolicy("computePolicy", new()
 *     {
 *         AccountName = "contosoadla",
 *         ComputePolicyName = "test_policy",
 *         MaxDegreeOfParallelismPerJob = 10,
 *         MinPriorityPerJob = 30,
 *         ObjectId = "776b9091-8916-4638-87f7-9c989a38da98",
 *         ObjectType = AzureNative.DataLakeAnalytics.AADObjectType.User,
 *         ResourceGroupName = "contosorg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datalakeanalytics/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datalakeanalytics.NewComputePolicy(ctx, "computePolicy", &datalakeanalytics.ComputePolicyArgs{
 * 			AccountName:                  pulumi.String("contosoadla"),
 * 			ComputePolicyName:            pulumi.String("test_policy"),
 * 			MaxDegreeOfParallelismPerJob: pulumi.Int(10),
 * 			MinPriorityPerJob:            pulumi.Int(30),
 * 			ObjectId:                     pulumi.String("776b9091-8916-4638-87f7-9c989a38da98"),
 * 			ObjectType:                   pulumi.String(datalakeanalytics.AADObjectTypeUser),
 * 			ResourceGroupName:            pulumi.String("contosorg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datalakeanalytics.ComputePolicy;
 * import com.pulumi.azurenative.datalakeanalytics.ComputePolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var computePolicy = new ComputePolicy("computePolicy", ComputePolicyArgs.builder()
 *             .accountName("contosoadla")
 *             .computePolicyName("test_policy")
 *             .maxDegreeOfParallelismPerJob(10)
 *             .minPriorityPerJob(30)
 *             .objectId("776b9091-8916-4638-87f7-9c989a38da98")
 *             .objectType("User")
 *             .resourceGroupName("contosorg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:datalakeanalytics:ComputePolicy test_policy /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts/{accountName}/computePolicies/{computePolicyName}
 * ```
 * @property accountName The name of the Data Lake Analytics account.
 * @property computePolicyName The name of the compute policy to create or update.
 * @property maxDegreeOfParallelismPerJob The maximum degree of parallelism per job this user can use to submit jobs. This property, the min priority per job property, or both must be passed.
 * @property minPriorityPerJob The minimum priority per job this user can use to submit jobs. This property, the max degree of parallelism per job property, or both must be passed.
 * @property objectId The AAD object identifier for the entity to create a policy for.
 * @property objectType The type of AAD object the object identifier refers to.
 * @property resourceGroupName The name of the Azure resource group.
 */
public data class ComputePolicyArgs(
    public val accountName: Output<String>? = null,
    public val computePolicyName: Output<String>? = null,
    public val maxDegreeOfParallelismPerJob: Output<Int>? = null,
    public val minPriorityPerJob: Output<Int>? = null,
    public val objectId: Output<String>? = null,
    public val objectType: Output<Either<String, AADObjectType>>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datalakeanalytics.ComputePolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.datalakeanalytics.ComputePolicyArgs =
        com.pulumi.azurenative.datalakeanalytics.ComputePolicyArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .computePolicyName(computePolicyName?.applyValue({ args0 -> args0 }))
            .maxDegreeOfParallelismPerJob(maxDegreeOfParallelismPerJob?.applyValue({ args0 -> args0 }))
            .minPriorityPerJob(minPriorityPerJob?.applyValue({ args0 -> args0 }))
            .objectId(objectId?.applyValue({ args0 -> args0 }))
            .objectType(
                objectType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ComputePolicyArgs].
 */
@PulumiTagMarker
public class ComputePolicyArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var computePolicyName: Output<String>? = null

    private var maxDegreeOfParallelismPerJob: Output<Int>? = null

    private var minPriorityPerJob: Output<Int>? = null

    private var objectId: Output<String>? = null

    private var objectType: Output<Either<String, AADObjectType>>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value The name of the Data Lake Analytics account.
     */
    @JvmName("vldfmpbwqribhwwq")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value The name of the compute policy to create or update.
     */
    @JvmName("ckjucuacbpssgsol")
    public suspend fun computePolicyName(`value`: Output<String>) {
        this.computePolicyName = value
    }

    /**
     * @param value The maximum degree of parallelism per job this user can use to submit jobs. This property, the min priority per job property, or both must be passed.
     */
    @JvmName("kxmikygcbmytybho")
    public suspend fun maxDegreeOfParallelismPerJob(`value`: Output<Int>) {
        this.maxDegreeOfParallelismPerJob = value
    }

    /**
     * @param value The minimum priority per job this user can use to submit jobs. This property, the max degree of parallelism per job property, or both must be passed.
     */
    @JvmName("xnambbhtqhgbvysu")
    public suspend fun minPriorityPerJob(`value`: Output<Int>) {
        this.minPriorityPerJob = value
    }

    /**
     * @param value The AAD object identifier for the entity to create a policy for.
     */
    @JvmName("mahgwpkaolbdmxbq")
    public suspend fun objectId(`value`: Output<String>) {
        this.objectId = value
    }

    /**
     * @param value The type of AAD object the object identifier refers to.
     */
    @JvmName("xdpmxbrxkseqjffm")
    public suspend fun objectType(`value`: Output<Either<String, AADObjectType>>) {
        this.objectType = value
    }

    /**
     * @param value The name of the Azure resource group.
     */
    @JvmName("kmscxyoeqbbwgnbi")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the Data Lake Analytics account.
     */
    @JvmName("amarqhxoggklpefk")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value The name of the compute policy to create or update.
     */
    @JvmName("ihciovnyudyrgmfc")
    public suspend fun computePolicyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.computePolicyName = mapped
    }

    /**
     * @param value The maximum degree of parallelism per job this user can use to submit jobs. This property, the min priority per job property, or both must be passed.
     */
    @JvmName("hyordfvfjcfucyie")
    public suspend fun maxDegreeOfParallelismPerJob(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxDegreeOfParallelismPerJob = mapped
    }

    /**
     * @param value The minimum priority per job this user can use to submit jobs. This property, the max degree of parallelism per job property, or both must be passed.
     */
    @JvmName("iusxmgtinqehlbva")
    public suspend fun minPriorityPerJob(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minPriorityPerJob = mapped
    }

    /**
     * @param value The AAD object identifier for the entity to create a policy for.
     */
    @JvmName("burqtufqktmeuopq")
    public suspend fun objectId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.objectId = mapped
    }

    /**
     * @param value The type of AAD object the object identifier refers to.
     */
    @JvmName("oertkcddkweknjvj")
    public suspend fun objectType(`value`: Either<String, AADObjectType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.objectType = mapped
    }

    /**
     * @param value The type of AAD object the object identifier refers to.
     */
    @JvmName("joovjbukbpdjowha")
    public fun objectType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AADObjectType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.objectType = mapped
    }

    /**
     * @param value The type of AAD object the object identifier refers to.
     */
    @JvmName("inpoxgtiynnuuafy")
    public fun objectType(`value`: AADObjectType) {
        val toBeMapped = Either.ofRight<String, AADObjectType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.objectType = mapped
    }

    /**
     * @param value The name of the Azure resource group.
     */
    @JvmName("jsbxpbdpxgirryyb")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): ComputePolicyArgs = ComputePolicyArgs(
        accountName = accountName,
        computePolicyName = computePolicyName,
        maxDegreeOfParallelismPerJob = maxDegreeOfParallelismPerJob,
        minPriorityPerJob = minPriorityPerJob,
        objectId = objectId,
        objectType = objectType,
        resourceGroupName = resourceGroupName,
    )
}
