@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datalakeanalytics.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The type of AAD object the object identifier refers to.
 */
public enum class AADObjectType(
    public val javaValue: com.pulumi.azurenative.datalakeanalytics.enums.AADObjectType,
) : ConvertibleToJava<com.pulumi.azurenative.datalakeanalytics.enums.AADObjectType> {
    User(com.pulumi.azurenative.datalakeanalytics.enums.AADObjectType.User),
    Group(com.pulumi.azurenative.datalakeanalytics.enums.AADObjectType.Group),
    ServicePrincipal(com.pulumi.azurenative.datalakeanalytics.enums.AADObjectType.ServicePrincipal),
    ;

    override fun toJava(): com.pulumi.azurenative.datalakeanalytics.enums.AADObjectType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datalakeanalytics.enums.AADObjectType): AADObjectType = AADObjectType.values().first { it.javaValue == javaType }
    }
}
