@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datalakeanalytics.kotlin.inputs

import com.pulumi.azurenative.datalakeanalytics.inputs.GetComputePolicyPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName The name of the Data Lake Analytics account.
 * @property computePolicyName The name of the compute policy to retrieve.
 * @property resourceGroupName The name of the Azure resource group.
 */
public data class GetComputePolicyPlainArgs(
    public val accountName: String,
    public val computePolicyName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.datalakeanalytics.inputs.GetComputePolicyPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.datalakeanalytics.inputs.GetComputePolicyPlainArgs =
        com.pulumi.azurenative.datalakeanalytics.inputs.GetComputePolicyPlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .computePolicyName(computePolicyName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetComputePolicyPlainArgs].
 */
@PulumiTagMarker
public class GetComputePolicyPlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var computePolicyName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the Data Lake Analytics account.
     */
    @JvmName("kcmigyxdexqlpbpd")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value The name of the compute policy to retrieve.
     */
    @JvmName("ojoijsmtjyxhksli")
    public suspend fun computePolicyName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.computePolicyName = mapped
    }

    /**
     * @param value The name of the Azure resource group.
     */
    @JvmName("hbdtgxhxkkugogek")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetComputePolicyPlainArgs = GetComputePolicyPlainArgs(
        accountName = accountName ?: throw PulumiNullFieldException("accountName"),
        computePolicyName = computePolicyName ?: throw PulumiNullFieldException("computePolicyName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
