@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datalakeanalytics.kotlin.inputs

import com.pulumi.azurenative.datalakeanalytics.inputs.ListStorageAccountSasTokensPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName The name of the Data Lake Analytics account.
 * @property containerName The name of the Azure storage container for which the SAS token is being requested.
 * @property resourceGroupName The name of the Azure resource group.
 * @property storageAccountName The name of the Azure storage account for which the SAS token is being requested.
 */
public data class ListStorageAccountSasTokensPlainArgs(
    public val accountName: String,
    public val containerName: String,
    public val resourceGroupName: String,
    public val storageAccountName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.datalakeanalytics.inputs.ListStorageAccountSasTokensPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.datalakeanalytics.inputs.ListStorageAccountSasTokensPlainArgs =
        com.pulumi.azurenative.datalakeanalytics.inputs.ListStorageAccountSasTokensPlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .containerName(containerName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .storageAccountName(storageAccountName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListStorageAccountSasTokensPlainArgs].
 */
@PulumiTagMarker
public class ListStorageAccountSasTokensPlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var containerName: String? = null

    private var resourceGroupName: String? = null

    private var storageAccountName: String? = null

    /**
     * @param value The name of the Data Lake Analytics account.
     */
    @JvmName("cxihdsercnotqgks")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value The name of the Azure storage container for which the SAS token is being requested.
     */
    @JvmName("wocfwarnfgjcgbna")
    public suspend fun containerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.containerName = mapped
    }

    /**
     * @param value The name of the Azure resource group.
     */
    @JvmName("kbpquruggahuiatw")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Azure storage account for which the SAS token is being requested.
     */
    @JvmName("lkudhneyfkjserhf")
    public suspend fun storageAccountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.storageAccountName = mapped
    }

    internal fun build(): ListStorageAccountSasTokensPlainArgs = ListStorageAccountSasTokensPlainArgs(
        accountName = accountName ?: throw PulumiNullFieldException("accountName"),
        containerName = containerName ?: throw PulumiNullFieldException("containerName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        storageAccountName = storageAccountName ?: throw PulumiNullFieldException("storageAccountName"),
    )
}
