@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datalakeanalytics.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Data Lake Store account information.
 * @property id The resource identifier.
 * @property name The resource name.
 * @property suffix The optional suffix for the Data Lake Store account.
 * @property type The resource type.
 */
public data class DataLakeStoreAccountInformationResponse(
    public val id: String,
    public val name: String,
    public val suffix: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datalakeanalytics.outputs.DataLakeStoreAccountInformationResponse): DataLakeStoreAccountInformationResponse = DataLakeStoreAccountInformationResponse(
            id = javaType.id(),
            name = javaType.name(),
            suffix = javaType.suffix(),
            type = javaType.type(),
        )
    }
}
