@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datalakeanalytics.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Data Lake Analytics compute policy information.
 * @property id The resource identifier.
 * @property maxDegreeOfParallelismPerJob The maximum degree of parallelism per job this user can use to submit jobs.
 * @property minPriorityPerJob The minimum priority per job this user can use to submit jobs.
 * @property name The resource name.
 * @property objectId The AAD object identifier for the entity to create a policy for.
 * @property objectType The type of AAD object the object identifier refers to.
 * @property type The resource type.
 */
public data class GetComputePolicyResult(
    public val id: String,
    public val maxDegreeOfParallelismPerJob: Int,
    public val minPriorityPerJob: Int,
    public val name: String,
    public val objectId: String,
    public val objectType: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datalakeanalytics.outputs.GetComputePolicyResult): GetComputePolicyResult = GetComputePolicyResult(
            id = javaType.id(),
            maxDegreeOfParallelismPerJob = javaType.maxDegreeOfParallelismPerJob(),
            minPriorityPerJob = javaType.minPriorityPerJob(),
            name = javaType.name(),
            objectId = javaType.objectId(),
            objectType = javaType.objectType(),
            type = javaType.type(),
        )
    }
}
