@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datalakeanalytics.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The SAS response that contains the storage account, container and associated SAS token for connection use.
 * @property nextLink The link (url) to the next page of results.
 * @property value The results of the list operation.
 */
public data class ListStorageAccountSasTokensResult(
    public val nextLink: String,
    public val `value`: List<SasTokenInformationResponse>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datalakeanalytics.outputs.ListStorageAccountSasTokensResult): ListStorageAccountSasTokensResult = ListStorageAccountSasTokensResult(
            nextLink = javaType.nextLink(),
            `value` = javaType.`value`().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datalakeanalytics.kotlin.outputs.SasTokenInformationResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
