@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datalakestore.kotlin

import com.pulumi.azurenative.datalakestore.AccountArgs.builder
import com.pulumi.azurenative.datalakestore.kotlin.enums.EncryptionState
import com.pulumi.azurenative.datalakestore.kotlin.enums.FirewallAllowAzureIpsState
import com.pulumi.azurenative.datalakestore.kotlin.enums.FirewallState
import com.pulumi.azurenative.datalakestore.kotlin.enums.TierType
import com.pulumi.azurenative.datalakestore.kotlin.enums.TrustedIdProviderState
import com.pulumi.azurenative.datalakestore.kotlin.inputs.CreateFirewallRuleWithAccountParametersArgs
import com.pulumi.azurenative.datalakestore.kotlin.inputs.CreateFirewallRuleWithAccountParametersArgsBuilder
import com.pulumi.azurenative.datalakestore.kotlin.inputs.CreateTrustedIdProviderWithAccountParametersArgs
import com.pulumi.azurenative.datalakestore.kotlin.inputs.CreateTrustedIdProviderWithAccountParametersArgsBuilder
import com.pulumi.azurenative.datalakestore.kotlin.inputs.CreateVirtualNetworkRuleWithAccountParametersArgs
import com.pulumi.azurenative.datalakestore.kotlin.inputs.CreateVirtualNetworkRuleWithAccountParametersArgsBuilder
import com.pulumi.azurenative.datalakestore.kotlin.inputs.EncryptionConfigArgs
import com.pulumi.azurenative.datalakestore.kotlin.inputs.EncryptionConfigArgsBuilder
import com.pulumi.azurenative.datalakestore.kotlin.inputs.EncryptionIdentityArgs
import com.pulumi.azurenative.datalakestore.kotlin.inputs.EncryptionIdentityArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Data Lake Store account information.
 * Azure REST API version: 2016-11-01. Prior API version in Azure Native 1.x: 2016-11-01.
 * ## Example Usage
 * ### Creates the specified Data Lake Store account
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var account = new AzureNative.DataLakeStore.Account("account", new()
 *     {
 *         AccountName = "contosoadla",
 *         DefaultGroup = "test_default_group",
 *         EncryptionConfig = new AzureNative.DataLakeStore.Inputs.EncryptionConfigArgs
 *         {
 *             KeyVaultMetaInfo = new AzureNative.DataLakeStore.Inputs.KeyVaultMetaInfoArgs
 *             {
 *                 EncryptionKeyName = "test_encryption_key_name",
 *                 EncryptionKeyVersion = "encryption_key_version",
 *                 KeyVaultResourceId = "34adfa4f-cedf-4dc0-ba29-b6d1a69ab345",
 *             },
 *             Type = AzureNative.DataLakeStore.EncryptionConfigType.UserManaged,
 *         },
 *         EncryptionState = AzureNative.DataLakeStore.EncryptionState.Enabled,
 *         FirewallAllowAzureIps = AzureNative.DataLakeStore.FirewallAllowAzureIpsState.Enabled,
 *         FirewallRules = new[]
 *         {
 *             new AzureNative.DataLakeStore.Inputs.CreateFirewallRuleWithAccountParametersArgs
 *             {
 *                 EndIpAddress = "2.2.2.2",
 *                 Name = "test_rule",
 *                 StartIpAddress = "1.1.1.1",
 *             },
 *         },
 *         FirewallState = AzureNative.DataLakeStore.FirewallState.Enabled,
 *         Identity = new AzureNative.DataLakeStore.Inputs.EncryptionIdentityArgs
 *         {
 *             Type = AzureNative.DataLakeStore.EncryptionIdentityType.SystemAssigned,
 *         },
 *         Location = "eastus2",
 *         NewTier = AzureNative.DataLakeStore.TierType.Consumption,
 *         ResourceGroupName = "contosorg",
 *         Tags =
 *         {
 *             { "test_key", "test_value" },
 *         },
 *         TrustedIdProviderState = AzureNative.DataLakeStore.TrustedIdProviderState.Enabled,
 *         TrustedIdProviders = new[]
 *         {
 *             new AzureNative.DataLakeStore.Inputs.CreateTrustedIdProviderWithAccountParametersArgs
 *             {
 *                 IdProvider = "https://sts.windows.net/ea9ec534-a3e3-4e45-ad36-3afc5bb291c1",
 *                 Name = "test_trusted_id_provider_name",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datalakestore/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datalakestore.NewAccount(ctx, "account", &datalakestore.AccountArgs{
 * 			AccountName:  pulumi.String("contosoadla"),
 * 			DefaultGroup: pulumi.String("test_default_group"),
 * 			EncryptionConfig: &datalakestore.EncryptionConfigArgs{
 * 				KeyVaultMetaInfo: &datalakestore.KeyVaultMetaInfoArgs{
 * 					EncryptionKeyName:    pulumi.String("test_encryption_key_name"),
 * 					EncryptionKeyVersion: pulumi.String("encryption_key_version"),
 * 					KeyVaultResourceId:   pulumi.String("34adfa4f-cedf-4dc0-ba29-b6d1a69ab345"),
 * 				},
 * 				Type: datalakestore.EncryptionConfigTypeUserManaged,
 * 			},
 * 			EncryptionState:       datalakestore.EncryptionStateEnabled,
 * 			FirewallAllowAzureIps: datalakestore.FirewallAllowAzureIpsStateEnabled,
 * 			FirewallRules: datalakestore.CreateFirewallRuleWithAccountParametersArray{
 * 				&datalakestore.CreateFirewallRuleWithAccountParametersArgs{
 * 					EndIpAddress:   pulumi.String("2.2.2.2"),
 * 					Name:           pulumi.String("test_rule"),
 * 					StartIpAddress: pulumi.String("1.1.1.1"),
 * 				},
 * 			},
 * 			FirewallState: datalakestore.FirewallStateEnabled,
 * 			Identity: &datalakestore.EncryptionIdentityArgs{
 * 				Type: datalakestore.EncryptionIdentityTypeSystemAssigned,
 * 			},
 * 			Location:          pulumi.String("eastus2"),
 * 			NewTier:           datalakestore.TierTypeConsumption,
 * 			ResourceGroupName: pulumi.String("contosorg"),
 * 			Tags: pulumi.StringMap{
 * 				"test_key": pulumi.String("test_value"),
 * 			},
 * 			TrustedIdProviderState: datalakestore.TrustedIdProviderStateEnabled,
 * 			TrustedIdProviders: datalakestore.CreateTrustedIdProviderWithAccountParametersArray{
 * 				&datalakestore.CreateTrustedIdProviderWithAccountParametersArgs{
 * 					IdProvider: pulumi.String("https://sts.windows.net/ea9ec534-a3e3-4e45-ad36-3afc5bb291c1"),
 * 					Name:       pulumi.String("test_trusted_id_provider_name"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datalakestore.Account;
 * import com.pulumi.azurenative.datalakestore.AccountArgs;
 * import com.pulumi.azurenative.datalakestore.inputs.EncryptionConfigArgs;
 * import com.pulumi.azurenative.datalakestore.inputs.KeyVaultMetaInfoArgs;
 * import com.pulumi.azurenative.datalakestore.inputs.CreateFirewallRuleWithAccountParametersArgs;
 * import com.pulumi.azurenative.datalakestore.inputs.EncryptionIdentityArgs;
 * import com.pulumi.azurenative.datalakestore.inputs.CreateTrustedIdProviderWithAccountParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var account = new Account("account", AccountArgs.builder()
 *             .accountName("contosoadla")
 *             .defaultGroup("test_default_group")
 *             .encryptionConfig(EncryptionConfigArgs.builder()
 *                 .keyVaultMetaInfo(KeyVaultMetaInfoArgs.builder()
 *                     .encryptionKeyName("test_encryption_key_name")
 *                     .encryptionKeyVersion("encryption_key_version")
 *                     .keyVaultResourceId("34adfa4f-cedf-4dc0-ba29-b6d1a69ab345")
 *                     .build())
 *                 .type("UserManaged")
 *                 .build())
 *             .encryptionState("Enabled")
 *             .firewallAllowAzureIps("Enabled")
 *             .firewallRules(CreateFirewallRuleWithAccountParametersArgs.builder()
 *                 .endIpAddress("2.2.2.2")
 *                 .name("test_rule")
 *                 .startIpAddress("1.1.1.1")
 *                 .build())
 *             .firewallState("Enabled")
 *             .identity(EncryptionIdentityArgs.builder()
 *                 .type("SystemAssigned")
 *                 .build())
 *             .location("eastus2")
 *             .newTier("Consumption")
 *             .resourceGroupName("contosorg")
 *             .tags(Map.of("test_key", "test_value"))
 *             .trustedIdProviderState("Enabled")
 *             .trustedIdProviders(CreateTrustedIdProviderWithAccountParametersArgs.builder()
 *                 .idProvider("https://sts.windows.net/ea9ec534-a3e3-4e45-ad36-3afc5bb291c1")
 *                 .name("test_trusted_id_provider_name")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:datalakestore:Account contosoadla /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeStore/accounts/{accountName}
 * ```
 * @property accountName The name of the Data Lake Store account.
 * @property defaultGroup The default owner group for all new folders and files created in the Data Lake Store account.
 * @property encryptionConfig The Key Vault encryption configuration.
 * @property encryptionState The current state of encryption for this Data Lake Store account.
 * @property firewallAllowAzureIps The current state of allowing or disallowing IPs originating within Azure through the firewall. If the firewall is disabled, this is not enforced.
 * @property firewallRules The list of firewall rules associated with this Data Lake Store account.
 * @property firewallState The current state of the IP address firewall for this Data Lake Store account.
 * @property identity The Key Vault encryption identity, if any.
 * @property location The resource location.
 * @property newTier The commitment tier to use for next month.
 * @property resourceGroupName The name of the Azure resource group.
 * @property tags The resource tags.
 * @property trustedIdProviderState The current state of the trusted identity provider feature for this Data Lake Store account.
 * @property trustedIdProviders The list of trusted identity providers associated with this Data Lake Store account.
 * @property virtualNetworkRules The list of virtual network rules associated with this Data Lake Store account.
 */
public data class AccountArgs(
    public val accountName: Output<String>? = null,
    public val defaultGroup: Output<String>? = null,
    public val encryptionConfig: Output<EncryptionConfigArgs>? = null,
    public val encryptionState: Output<EncryptionState>? = null,
    public val firewallAllowAzureIps: Output<FirewallAllowAzureIpsState>? = null,
    public val firewallRules: Output<List<CreateFirewallRuleWithAccountParametersArgs>>? = null,
    public val firewallState: Output<FirewallState>? = null,
    public val identity: Output<EncryptionIdentityArgs>? = null,
    public val location: Output<String>? = null,
    public val newTier: Output<TierType>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val trustedIdProviderState: Output<TrustedIdProviderState>? = null,
    public val trustedIdProviders: Output<List<CreateTrustedIdProviderWithAccountParametersArgs>>? =
        null,
    public val virtualNetworkRules: Output<List<CreateVirtualNetworkRuleWithAccountParametersArgs>>? =
        null,
) : ConvertibleToJava<com.pulumi.azurenative.datalakestore.AccountArgs> {
    override fun toJava(): com.pulumi.azurenative.datalakestore.AccountArgs =
        com.pulumi.azurenative.datalakestore.AccountArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .defaultGroup(defaultGroup?.applyValue({ args0 -> args0 }))
            .encryptionConfig(encryptionConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .encryptionState(encryptionState?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .firewallAllowAzureIps(
                firewallAllowAzureIps?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .firewallRules(
                firewallRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .firewallState(firewallState?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .newTier(newTier?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .trustedIdProviderState(
                trustedIdProviderState?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .trustedIdProviders(
                trustedIdProviders?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .virtualNetworkRules(
                virtualNetworkRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [AccountArgs].
 */
@PulumiTagMarker
public class AccountArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var defaultGroup: Output<String>? = null

    private var encryptionConfig: Output<EncryptionConfigArgs>? = null

    private var encryptionState: Output<EncryptionState>? = null

    private var firewallAllowAzureIps: Output<FirewallAllowAzureIpsState>? = null

    private var firewallRules: Output<List<CreateFirewallRuleWithAccountParametersArgs>>? = null

    private var firewallState: Output<FirewallState>? = null

    private var identity: Output<EncryptionIdentityArgs>? = null

    private var location: Output<String>? = null

    private var newTier: Output<TierType>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var trustedIdProviderState: Output<TrustedIdProviderState>? = null

    private var trustedIdProviders: Output<List<CreateTrustedIdProviderWithAccountParametersArgs>>? =
        null

    private var virtualNetworkRules: Output<List<CreateVirtualNetworkRuleWithAccountParametersArgs>>? =
        null

    /**
     * @param value The name of the Data Lake Store account.
     */
    @JvmName("axpdykfnxirsviva")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value The default owner group for all new folders and files created in the Data Lake Store account.
     */
    @JvmName("kjumsmcqxhbufcvu")
    public suspend fun defaultGroup(`value`: Output<String>) {
        this.defaultGroup = value
    }

    /**
     * @param value The Key Vault encryption configuration.
     */
    @JvmName("bwdlfruyrxxxicxk")
    public suspend fun encryptionConfig(`value`: Output<EncryptionConfigArgs>) {
        this.encryptionConfig = value
    }

    /**
     * @param value The current state of encryption for this Data Lake Store account.
     */
    @JvmName("skyboeswaensxqsk")
    public suspend fun encryptionState(`value`: Output<EncryptionState>) {
        this.encryptionState = value
    }

    /**
     * @param value The current state of allowing or disallowing IPs originating within Azure through the firewall. If the firewall is disabled, this is not enforced.
     */
    @JvmName("heqfqoqulpbyuvwv")
    public suspend fun firewallAllowAzureIps(`value`: Output<FirewallAllowAzureIpsState>) {
        this.firewallAllowAzureIps = value
    }

    /**
     * @param value The list of firewall rules associated with this Data Lake Store account.
     */
    @JvmName("jixfyvjgxnltiohe")
    public suspend fun firewallRules(`value`: Output<List<CreateFirewallRuleWithAccountParametersArgs>>) {
        this.firewallRules = value
    }

    @JvmName("bcdwnhwmnkgshrap")
    public suspend fun firewallRules(vararg values: Output<CreateFirewallRuleWithAccountParametersArgs>) {
        this.firewallRules = Output.all(values.asList())
    }

    /**
     * @param values The list of firewall rules associated with this Data Lake Store account.
     */
    @JvmName("hwvbmpiryucborlk")
    public suspend fun firewallRules(values: List<Output<CreateFirewallRuleWithAccountParametersArgs>>) {
        this.firewallRules = Output.all(values)
    }

    /**
     * @param value The current state of the IP address firewall for this Data Lake Store account.
     */
    @JvmName("vplrciyrhnqnmgss")
    public suspend fun firewallState(`value`: Output<FirewallState>) {
        this.firewallState = value
    }

    /**
     * @param value The Key Vault encryption identity, if any.
     */
    @JvmName("plhigfbjyagnvfiv")
    public suspend fun identity(`value`: Output<EncryptionIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value The resource location.
     */
    @JvmName("uwxxajjkoopnqcnr")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The commitment tier to use for next month.
     */
    @JvmName("ohxkbtlxlhgbgftd")
    public suspend fun newTier(`value`: Output<TierType>) {
        this.newTier = value
    }

    /**
     * @param value The name of the Azure resource group.
     */
    @JvmName("gkygudlquhepaixh")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The resource tags.
     */
    @JvmName("siaitbtgfcgnvsgd")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The current state of the trusted identity provider feature for this Data Lake Store account.
     */
    @JvmName("hvetrfllurcltwwk")
    public suspend fun trustedIdProviderState(`value`: Output<TrustedIdProviderState>) {
        this.trustedIdProviderState = value
    }

    /**
     * @param value The list of trusted identity providers associated with this Data Lake Store account.
     */
    @JvmName("gdphcuqmanmqoeay")
    public suspend fun trustedIdProviders(`value`: Output<List<CreateTrustedIdProviderWithAccountParametersArgs>>) {
        this.trustedIdProviders = value
    }

    @JvmName("hqjghafwgbxupalj")
    public suspend fun trustedIdProviders(vararg values: Output<CreateTrustedIdProviderWithAccountParametersArgs>) {
        this.trustedIdProviders = Output.all(values.asList())
    }

    /**
     * @param values The list of trusted identity providers associated with this Data Lake Store account.
     */
    @JvmName("idsgjptinbafyfta")
    public suspend fun trustedIdProviders(values: List<Output<CreateTrustedIdProviderWithAccountParametersArgs>>) {
        this.trustedIdProviders = Output.all(values)
    }

    /**
     * @param value The list of virtual network rules associated with this Data Lake Store account.
     */
    @JvmName("jxrepfebgvtsrfgm")
    public suspend fun virtualNetworkRules(`value`: Output<List<CreateVirtualNetworkRuleWithAccountParametersArgs>>) {
        this.virtualNetworkRules = value
    }

    @JvmName("ixwaqcvhfyjraesg")
    public suspend fun virtualNetworkRules(vararg values: Output<CreateVirtualNetworkRuleWithAccountParametersArgs>) {
        this.virtualNetworkRules = Output.all(values.asList())
    }

    /**
     * @param values The list of virtual network rules associated with this Data Lake Store account.
     */
    @JvmName("snivifglawhkvqca")
    public suspend fun virtualNetworkRules(values: List<Output<CreateVirtualNetworkRuleWithAccountParametersArgs>>) {
        this.virtualNetworkRules = Output.all(values)
    }

    /**
     * @param value The name of the Data Lake Store account.
     */
    @JvmName("ndyctllbxvxjlyab")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value The default owner group for all new folders and files created in the Data Lake Store account.
     */
    @JvmName("dlcaxmasjuefhnlt")
    public suspend fun defaultGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultGroup = mapped
    }

    /**
     * @param value The Key Vault encryption configuration.
     */
    @JvmName("xlqaqcdtlxykqtix")
    public suspend fun encryptionConfig(`value`: EncryptionConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionConfig = mapped
    }

    /**
     * @param argument The Key Vault encryption configuration.
     */
    @JvmName("rfedfnqkgebhoqbj")
    public suspend fun encryptionConfig(argument: suspend EncryptionConfigArgsBuilder.() -> Unit) {
        val toBeMapped = EncryptionConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.encryptionConfig = mapped
    }

    /**
     * @param value The current state of encryption for this Data Lake Store account.
     */
    @JvmName("haeuvrgxxqrhetkl")
    public suspend fun encryptionState(`value`: EncryptionState?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionState = mapped
    }

    /**
     * @param value The current state of allowing or disallowing IPs originating within Azure through the firewall. If the firewall is disabled, this is not enforced.
     */
    @JvmName("nccfpgevakasuyfd")
    public suspend fun firewallAllowAzureIps(`value`: FirewallAllowAzureIpsState?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.firewallAllowAzureIps = mapped
    }

    /**
     * @param value The list of firewall rules associated with this Data Lake Store account.
     */
    @JvmName("ogrjgrymvpnktwqn")
    public suspend fun firewallRules(`value`: List<CreateFirewallRuleWithAccountParametersArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.firewallRules = mapped
    }

    /**
     * @param argument The list of firewall rules associated with this Data Lake Store account.
     */
    @JvmName("nswqdrawhjaqhdko")
    public suspend fun firewallRules(argument: List<suspend CreateFirewallRuleWithAccountParametersArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            CreateFirewallRuleWithAccountParametersArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.firewallRules = mapped
    }

    /**
     * @param argument The list of firewall rules associated with this Data Lake Store account.
     */
    @JvmName("qmtmlnclxmhdslyy")
    public suspend fun firewallRules(vararg argument: suspend CreateFirewallRuleWithAccountParametersArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            CreateFirewallRuleWithAccountParametersArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.firewallRules = mapped
    }

    /**
     * @param argument The list of firewall rules associated with this Data Lake Store account.
     */
    @JvmName("sskuhjovmlqulxjn")
    public suspend fun firewallRules(argument: suspend CreateFirewallRuleWithAccountParametersArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            CreateFirewallRuleWithAccountParametersArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.firewallRules = mapped
    }

    /**
     * @param values The list of firewall rules associated with this Data Lake Store account.
     */
    @JvmName("fnrsngrkplxrbdwx")
    public suspend fun firewallRules(vararg values: CreateFirewallRuleWithAccountParametersArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.firewallRules = mapped
    }

    /**
     * @param value The current state of the IP address firewall for this Data Lake Store account.
     */
    @JvmName("yixmmyrmiubwlome")
    public suspend fun firewallState(`value`: FirewallState?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.firewallState = mapped
    }

    /**
     * @param value The Key Vault encryption identity, if any.
     */
    @JvmName("dtdjhhtkcckhlnjf")
    public suspend fun identity(`value`: EncryptionIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument The Key Vault encryption identity, if any.
     */
    @JvmName("mgwfqakmaanepuiu")
    public suspend fun identity(argument: suspend EncryptionIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = EncryptionIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The resource location.
     */
    @JvmName("jghncfksikyjupyr")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The commitment tier to use for next month.
     */
    @JvmName("cktnmpmtqfiqvbds")
    public suspend fun newTier(`value`: TierType?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.newTier = mapped
    }

    /**
     * @param value The name of the Azure resource group.
     */
    @JvmName("qemdhgdwmrqhwgue")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The resource tags.
     */
    @JvmName("kfexwdiusvgvovgs")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The resource tags.
     */
    @JvmName("evixvlbtssfxggsg")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The current state of the trusted identity provider feature for this Data Lake Store account.
     */
    @JvmName("trxrkcsicmloeyxc")
    public suspend fun trustedIdProviderState(`value`: TrustedIdProviderState?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trustedIdProviderState = mapped
    }

    /**
     * @param value The list of trusted identity providers associated with this Data Lake Store account.
     */
    @JvmName("wvhedulfxcsatxie")
    public suspend fun trustedIdProviders(`value`: List<CreateTrustedIdProviderWithAccountParametersArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trustedIdProviders = mapped
    }

    /**
     * @param argument The list of trusted identity providers associated with this Data Lake Store account.
     */
    @JvmName("rwabvyuuhcttbemi")
    public suspend fun trustedIdProviders(argument: List<suspend CreateTrustedIdProviderWithAccountParametersArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            CreateTrustedIdProviderWithAccountParametersArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.trustedIdProviders = mapped
    }

    /**
     * @param argument The list of trusted identity providers associated with this Data Lake Store account.
     */
    @JvmName("etpgyjwfmfjuqwmx")
    public suspend fun trustedIdProviders(vararg argument: suspend CreateTrustedIdProviderWithAccountParametersArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            CreateTrustedIdProviderWithAccountParametersArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.trustedIdProviders = mapped
    }

    /**
     * @param argument The list of trusted identity providers associated with this Data Lake Store account.
     */
    @JvmName("kandspbaseacfdlv")
    public suspend fun trustedIdProviders(argument: suspend CreateTrustedIdProviderWithAccountParametersArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            CreateTrustedIdProviderWithAccountParametersArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.trustedIdProviders = mapped
    }

    /**
     * @param values The list of trusted identity providers associated with this Data Lake Store account.
     */
    @JvmName("xppnluntokavbiae")
    public suspend fun trustedIdProviders(vararg values: CreateTrustedIdProviderWithAccountParametersArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.trustedIdProviders = mapped
    }

    /**
     * @param value The list of virtual network rules associated with this Data Lake Store account.
     */
    @JvmName("gecwoxynlpauptxk")
    public suspend fun virtualNetworkRules(`value`: List<CreateVirtualNetworkRuleWithAccountParametersArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualNetworkRules = mapped
    }

    /**
     * @param argument The list of virtual network rules associated with this Data Lake Store account.
     */
    @JvmName("phbwynjwjxojtaqg")
    public suspend fun virtualNetworkRules(argument: List<suspend CreateVirtualNetworkRuleWithAccountParametersArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            CreateVirtualNetworkRuleWithAccountParametersArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.virtualNetworkRules = mapped
    }

    /**
     * @param argument The list of virtual network rules associated with this Data Lake Store account.
     */
    @JvmName("nhqdwhfxabwabmdi")
    public suspend fun virtualNetworkRules(vararg argument: suspend CreateVirtualNetworkRuleWithAccountParametersArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            CreateVirtualNetworkRuleWithAccountParametersArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.virtualNetworkRules = mapped
    }

    /**
     * @param argument The list of virtual network rules associated with this Data Lake Store account.
     */
    @JvmName("kcbhsjjualvneoal")
    public suspend fun virtualNetworkRules(argument: suspend CreateVirtualNetworkRuleWithAccountParametersArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            CreateVirtualNetworkRuleWithAccountParametersArgsBuilder().applySuspend
                { argument() }.build(),
        )
        val mapped = of(toBeMapped)
        this.virtualNetworkRules = mapped
    }

    /**
     * @param values The list of virtual network rules associated with this Data Lake Store account.
     */
    @JvmName("isuvhlvqydwnbxul")
    public suspend fun virtualNetworkRules(vararg values: CreateVirtualNetworkRuleWithAccountParametersArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.virtualNetworkRules = mapped
    }

    internal fun build(): AccountArgs = AccountArgs(
        accountName = accountName,
        defaultGroup = defaultGroup,
        encryptionConfig = encryptionConfig,
        encryptionState = encryptionState,
        firewallAllowAzureIps = firewallAllowAzureIps,
        firewallRules = firewallRules,
        firewallState = firewallState,
        identity = identity,
        location = location,
        newTier = newTier,
        resourceGroupName = resourceGroupName,
        tags = tags,
        trustedIdProviderState = trustedIdProviderState,
        trustedIdProviders = trustedIdProviders,
        virtualNetworkRules = virtualNetworkRules,
    )
}
