@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datalakestore.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [TrustedIdProvider].
 */
@PulumiTagMarker
public class TrustedIdProviderResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TrustedIdProviderArgs = TrustedIdProviderArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TrustedIdProviderArgsBuilder.() -> Unit) {
        val builder = TrustedIdProviderArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): TrustedIdProvider {
        val builtJavaResource =
            com.pulumi.azurenative.datalakestore.TrustedIdProvider(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return TrustedIdProvider(builtJavaResource)
    }
}

/**
 * Data Lake Store trusted identity provider information.
 * Azure REST API version: 2016-11-01. Prior API version in Azure Native 1.x: 2016-11-01.
 * ## Example Usage
 * ### Creates or updates the specified trusted identity provider. During update, the trusted identity provider with the specified name will be replaced with this new provider
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var trustedIdProvider = new AzureNative.DataLakeStore.TrustedIdProvider("trustedIdProvider", new()
 *     {
 *         AccountName = "contosoadla",
 *         IdProvider = "https://sts.windows.net/ea9ec534-a3e3-4e45-ad36-3afc5bb291c1",
 *         ResourceGroupName = "contosorg",
 *         TrustedIdProviderName = "test_trusted_id_provider_name",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datalakestore/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datalakestore.NewTrustedIdProvider(ctx, "trustedIdProvider", &datalakestore.TrustedIdProviderArgs{
 * 			AccountName:           pulumi.String("contosoadla"),
 * 			IdProvider:            pulumi.String("https://sts.windows.net/ea9ec534-a3e3-4e45-ad36-3afc5bb291c1"),
 * 			ResourceGroupName:     pulumi.String("contosorg"),
 * 			TrustedIdProviderName: pulumi.String("test_trusted_id_provider_name"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datalakestore.TrustedIdProvider;
 * import com.pulumi.azurenative.datalakestore.TrustedIdProviderArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var trustedIdProvider = new TrustedIdProvider("trustedIdProvider", TrustedIdProviderArgs.builder()
 *             .accountName("contosoadla")
 *             .idProvider("https://sts.windows.net/ea9ec534-a3e3-4e45-ad36-3afc5bb291c1")
 *             .resourceGroupName("contosorg")
 *             .trustedIdProviderName("test_trusted_id_provider_name")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:datalakestore:TrustedIdProvider test_trusted_id_provider_name /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeStore/accounts/{accountName}/trustedIdProviders/{trustedIdProviderName}
 * ```
 */
public class TrustedIdProvider internal constructor(
    override val javaResource: com.pulumi.azurenative.datalakestore.TrustedIdProvider,
) : KotlinCustomResource(javaResource, TrustedIdProviderMapper) {
    /**
     * The URL of this trusted identity provider.
     */
    public val idProvider: Output<String>
        get() = javaResource.idProvider().applyValue({ args0 -> args0 })

    /**
     * The resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object TrustedIdProviderMapper : ResourceMapper<TrustedIdProvider> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.datalakestore.TrustedIdProvider::class == javaResource::class

    override fun map(javaResource: Resource): TrustedIdProvider = TrustedIdProvider(
        javaResource as
            com.pulumi.azurenative.datalakestore.TrustedIdProvider,
    )
}

/**
 * @see [TrustedIdProvider].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [TrustedIdProvider].
 */
public suspend fun trustedIdProvider(
    name: String,
    block: suspend TrustedIdProviderResourceBuilder.() -> Unit,
): TrustedIdProvider {
    val builder = TrustedIdProviderResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [TrustedIdProvider].
 * @param name The _unique_ name of the resulting resource.
 */
public fun trustedIdProvider(name: String): TrustedIdProvider {
    val builder = TrustedIdProviderResourceBuilder()
    builder.name(name)
    return builder.build()
}
