@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datalakestore.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The current state of encryption for this Data Lake Store account.
 */
public enum class EncryptionState(
    public val javaValue: com.pulumi.azurenative.datalakestore.enums.EncryptionState,
) : ConvertibleToJava<com.pulumi.azurenative.datalakestore.enums.EncryptionState> {
    Enabled(com.pulumi.azurenative.datalakestore.enums.EncryptionState.Enabled),
    Disabled(com.pulumi.azurenative.datalakestore.enums.EncryptionState.Disabled),
    ;

    override fun toJava(): com.pulumi.azurenative.datalakestore.enums.EncryptionState = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datalakestore.enums.EncryptionState): EncryptionState = EncryptionState.values().first { it.javaValue == javaType }
    }
}
