@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datalakestore.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The current state of allowing or disallowing IPs originating within Azure through the firewall. If the firewall is disabled, this is not enforced.
 */
public enum class FirewallAllowAzureIpsState(
    public val javaValue: com.pulumi.azurenative.datalakestore.enums.FirewallAllowAzureIpsState,
) : ConvertibleToJava<com.pulumi.azurenative.datalakestore.enums.FirewallAllowAzureIpsState> {
    Enabled(com.pulumi.azurenative.datalakestore.enums.FirewallAllowAzureIpsState.Enabled),
    Disabled(com.pulumi.azurenative.datalakestore.enums.FirewallAllowAzureIpsState.Disabled),
    ;

    override fun toJava(): com.pulumi.azurenative.datalakestore.enums.FirewallAllowAzureIpsState =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datalakestore.enums.FirewallAllowAzureIpsState): FirewallAllowAzureIpsState =
            FirewallAllowAzureIpsState.values().first { it.javaValue == javaType }
    }
}
