@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datalakestore.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The current state of the IP address firewall for this Data Lake Store account.
 */
public enum class FirewallState(
    public val javaValue: com.pulumi.azurenative.datalakestore.enums.FirewallState,
) : ConvertibleToJava<com.pulumi.azurenative.datalakestore.enums.FirewallState> {
    Enabled(com.pulumi.azurenative.datalakestore.enums.FirewallState.Enabled),
    Disabled(com.pulumi.azurenative.datalakestore.enums.FirewallState.Disabled),
    ;

    override fun toJava(): com.pulumi.azurenative.datalakestore.enums.FirewallState = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datalakestore.enums.FirewallState): FirewallState = FirewallState.values().first { it.javaValue == javaType }
    }
}
