@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datalakestore.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The current state of the trusted identity provider feature for this Data Lake Store account.
 */
public enum class TrustedIdProviderState(
    public val javaValue: com.pulumi.azurenative.datalakestore.enums.TrustedIdProviderState,
) : ConvertibleToJava<com.pulumi.azurenative.datalakestore.enums.TrustedIdProviderState> {
    Enabled(com.pulumi.azurenative.datalakestore.enums.TrustedIdProviderState.Enabled),
    Disabled(com.pulumi.azurenative.datalakestore.enums.TrustedIdProviderState.Disabled),
    ;

    override fun toJava(): com.pulumi.azurenative.datalakestore.enums.TrustedIdProviderState =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datalakestore.enums.TrustedIdProviderState): TrustedIdProviderState = TrustedIdProviderState.values().first { it.javaValue == javaType }
    }
}
