@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datalakestore.kotlin.inputs

import com.pulumi.azurenative.datalakestore.inputs.EncryptionIdentityArgs.builder
import com.pulumi.azurenative.datalakestore.kotlin.enums.EncryptionIdentityType
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The encryption identity properties.
 * @property type The type of encryption being used. Currently the only supported type is 'SystemAssigned'.
 */
public data class EncryptionIdentityArgs(
    public val type: Output<EncryptionIdentityType>,
) : ConvertibleToJava<com.pulumi.azurenative.datalakestore.inputs.EncryptionIdentityArgs> {
    override fun toJava(): com.pulumi.azurenative.datalakestore.inputs.EncryptionIdentityArgs =
        com.pulumi.azurenative.datalakestore.inputs.EncryptionIdentityArgs.builder()
            .type(type.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [EncryptionIdentityArgs].
 */
@PulumiTagMarker
public class EncryptionIdentityArgsBuilder internal constructor() {
    private var type: Output<EncryptionIdentityType>? = null

    /**
     * @param value The type of encryption being used. Currently the only supported type is 'SystemAssigned'.
     */
    @JvmName("ntedllcxxttqjvyu")
    public suspend fun type(`value`: Output<EncryptionIdentityType>) {
        this.type = value
    }

    /**
     * @param value The type of encryption being used. Currently the only supported type is 'SystemAssigned'.
     */
    @JvmName("vyochlwjlwewffdx")
    public suspend fun type(`value`: EncryptionIdentityType) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): EncryptionIdentityArgs = EncryptionIdentityArgs(
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
