@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datalakestore.kotlin.inputs

import com.pulumi.azurenative.datalakestore.inputs.GetVirtualNetworkRulePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName The name of the Data Lake Store account.
 * @property resourceGroupName The name of the Azure resource group.
 * @property virtualNetworkRuleName The name of the virtual network rule to retrieve.
 */
public data class GetVirtualNetworkRulePlainArgs(
    public val accountName: String,
    public val resourceGroupName: String,
    public val virtualNetworkRuleName: String,
) : ConvertibleToJava<com.pulumi.azurenative.datalakestore.inputs.GetVirtualNetworkRulePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.datalakestore.inputs.GetVirtualNetworkRulePlainArgs = com.pulumi.azurenative.datalakestore.inputs.GetVirtualNetworkRulePlainArgs.builder()
        .accountName(accountName.let({ args0 -> args0 }))
        .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
        .virtualNetworkRuleName(virtualNetworkRuleName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVirtualNetworkRulePlainArgs].
 */
@PulumiTagMarker
public class GetVirtualNetworkRulePlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var resourceGroupName: String? = null

    private var virtualNetworkRuleName: String? = null

    /**
     * @param value The name of the Data Lake Store account.
     */
    @JvmName("wjsgfdgckgrgbuhq")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value The name of the Azure resource group.
     */
    @JvmName("kgtemfbsnbuxcbme")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the virtual network rule to retrieve.
     */
    @JvmName("srflbwodguptyqqi")
    public suspend fun virtualNetworkRuleName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.virtualNetworkRuleName = mapped
    }

    internal fun build(): GetVirtualNetworkRulePlainArgs = GetVirtualNetworkRulePlainArgs(
        accountName = accountName ?: throw PulumiNullFieldException("accountName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        virtualNetworkRuleName = virtualNetworkRuleName ?: throw
            PulumiNullFieldException("virtualNetworkRuleName"),
    )
}
