@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datalakestore.kotlin.inputs

import com.pulumi.azurenative.datalakestore.inputs.KeyVaultMetaInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Metadata information used by account encryption.
 * @property encryptionKeyName The name of the user managed encryption key.
 * @property encryptionKeyVersion The version of the user managed encryption key.
 * @property keyVaultResourceId The resource identifier for the user managed Key Vault being used to encrypt.
 */
public data class KeyVaultMetaInfoArgs(
    public val encryptionKeyName: Output<String>,
    public val encryptionKeyVersion: Output<String>,
    public val keyVaultResourceId: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datalakestore.inputs.KeyVaultMetaInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.datalakestore.inputs.KeyVaultMetaInfoArgs =
        com.pulumi.azurenative.datalakestore.inputs.KeyVaultMetaInfoArgs.builder()
            .encryptionKeyName(encryptionKeyName.applyValue({ args0 -> args0 }))
            .encryptionKeyVersion(encryptionKeyVersion.applyValue({ args0 -> args0 }))
            .keyVaultResourceId(keyVaultResourceId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KeyVaultMetaInfoArgs].
 */
@PulumiTagMarker
public class KeyVaultMetaInfoArgsBuilder internal constructor() {
    private var encryptionKeyName: Output<String>? = null

    private var encryptionKeyVersion: Output<String>? = null

    private var keyVaultResourceId: Output<String>? = null

    /**
     * @param value The name of the user managed encryption key.
     */
    @JvmName("lpjesgxdqwpvlbhv")
    public suspend fun encryptionKeyName(`value`: Output<String>) {
        this.encryptionKeyName = value
    }

    /**
     * @param value The version of the user managed encryption key.
     */
    @JvmName("rlppcdyijjhwdapt")
    public suspend fun encryptionKeyVersion(`value`: Output<String>) {
        this.encryptionKeyVersion = value
    }

    /**
     * @param value The resource identifier for the user managed Key Vault being used to encrypt.
     */
    @JvmName("qgwotxugcdlxeaqu")
    public suspend fun keyVaultResourceId(`value`: Output<String>) {
        this.keyVaultResourceId = value
    }

    /**
     * @param value The name of the user managed encryption key.
     */
    @JvmName("flkwwagptfrbtxid")
    public suspend fun encryptionKeyName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.encryptionKeyName = mapped
    }

    /**
     * @param value The version of the user managed encryption key.
     */
    @JvmName("dlamyqthuhqlcwuq")
    public suspend fun encryptionKeyVersion(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.encryptionKeyVersion = mapped
    }

    /**
     * @param value The resource identifier for the user managed Key Vault being used to encrypt.
     */
    @JvmName("kgvpvtgkiettfafd")
    public suspend fun keyVaultResourceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keyVaultResourceId = mapped
    }

    internal fun build(): KeyVaultMetaInfoArgs = KeyVaultMetaInfoArgs(
        encryptionKeyName = encryptionKeyName ?: throw PulumiNullFieldException("encryptionKeyName"),
        encryptionKeyVersion = encryptionKeyVersion ?: throw
            PulumiNullFieldException("encryptionKeyVersion"),
        keyVaultResourceId = keyVaultResourceId ?: throw PulumiNullFieldException("keyVaultResourceId"),
    )
}
