@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datalakestore.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Data Lake Store account information.
 * @property accountId The unique identifier associated with this Data Lake Store account.
 * @property creationTime The account creation time.
 * @property currentTier The commitment tier in use for the current month.
 * @property defaultGroup The default owner group for all new folders and files created in the Data Lake Store account.
 * @property encryptionConfig The Key Vault encryption configuration.
 * @property encryptionProvisioningState The current state of encryption provisioning for this Data Lake Store account.
 * @property encryptionState The current state of encryption for this Data Lake Store account.
 * @property endpoint The full CName endpoint for this account.
 * @property firewallAllowAzureIps The current state of allowing or disallowing IPs originating within Azure through the firewall. If the firewall is disabled, this is not enforced.
 * @property firewallRules The list of firewall rules associated with this Data Lake Store account.
 * @property firewallState The current state of the IP address firewall for this Data Lake Store account.
 * @property id The resource identifier.
 * @property identity The Key Vault encryption identity, if any.
 * @property lastModifiedTime The account last modified time.
 * @property location The resource location.
 * @property name The resource name.
 * @property newTier The commitment tier to use for next month.
 * @property provisioningState The provisioning status of the Data Lake Store account.
 * @property state The state of the Data Lake Store account.
 * @property tags The resource tags.
 * @property trustedIdProviderState The current state of the trusted identity provider feature for this Data Lake Store account.
 * @property trustedIdProviders The list of trusted identity providers associated with this Data Lake Store account.
 * @property type The resource type.
 * @property virtualNetworkRules The list of virtual network rules associated with this Data Lake Store account.
 */
public data class GetAccountResult(
    public val accountId: String,
    public val creationTime: String,
    public val currentTier: String,
    public val defaultGroup: String,
    public val encryptionConfig: EncryptionConfigResponse,
    public val encryptionProvisioningState: String,
    public val encryptionState: String,
    public val endpoint: String,
    public val firewallAllowAzureIps: String,
    public val firewallRules: List<FirewallRuleResponse>,
    public val firewallState: String,
    public val id: String,
    public val identity: EncryptionIdentityResponse,
    public val lastModifiedTime: String,
    public val location: String,
    public val name: String,
    public val newTier: String,
    public val provisioningState: String,
    public val state: String,
    public val tags: Map<String, String>,
    public val trustedIdProviderState: String,
    public val trustedIdProviders: List<TrustedIdProviderResponse>,
    public val type: String,
    public val virtualNetworkRules: List<VirtualNetworkRuleResponse>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datalakestore.outputs.GetAccountResult): GetAccountResult = GetAccountResult(
            accountId = javaType.accountId(),
            creationTime = javaType.creationTime(),
            currentTier = javaType.currentTier(),
            defaultGroup = javaType.defaultGroup(),
            encryptionConfig = javaType.encryptionConfig().let({ args0 ->
                com.pulumi.azurenative.datalakestore.kotlin.outputs.EncryptionConfigResponse.Companion.toKotlin(args0)
            }),
            encryptionProvisioningState = javaType.encryptionProvisioningState(),
            encryptionState = javaType.encryptionState(),
            endpoint = javaType.endpoint(),
            firewallAllowAzureIps = javaType.firewallAllowAzureIps(),
            firewallRules = javaType.firewallRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datalakestore.kotlin.outputs.FirewallRuleResponse.Companion.toKotlin(args0)
                })
            }),
            firewallState = javaType.firewallState(),
            id = javaType.id(),
            identity = javaType.identity().let({ args0 ->
                com.pulumi.azurenative.datalakestore.kotlin.outputs.EncryptionIdentityResponse.Companion.toKotlin(args0)
            }),
            lastModifiedTime = javaType.lastModifiedTime(),
            location = javaType.location(),
            name = javaType.name(),
            newTier = javaType.newTier(),
            provisioningState = javaType.provisioningState(),
            state = javaType.state(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            trustedIdProviderState = javaType.trustedIdProviderState(),
            trustedIdProviders = javaType.trustedIdProviders().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datalakestore.kotlin.outputs.TrustedIdProviderResponse.Companion.toKotlin(args0)
                })
            }),
            type = javaType.type(),
            virtualNetworkRules = javaType.virtualNetworkRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datalakestore.kotlin.outputs.VirtualNetworkRuleResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
