@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datalakestore.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Data Lake Store firewall rule information.
 * @property endIpAddress The end IP address for the firewall rule. This can be either ipv4 or ipv6. Start and End should be in the same protocol.
 * @property id The resource identifier.
 * @property name The resource name.
 * @property startIpAddress The start IP address for the firewall rule. This can be either ipv4 or ipv6. Start and End should be in the same protocol.
 * @property type The resource type.
 */
public data class GetFirewallRuleResult(
    public val endIpAddress: String,
    public val id: String,
    public val name: String,
    public val startIpAddress: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datalakestore.outputs.GetFirewallRuleResult): GetFirewallRuleResult = GetFirewallRuleResult(
            endIpAddress = javaType.endIpAddress(),
            id = javaType.id(),
            name = javaType.name(),
            startIpAddress = javaType.startIpAddress(),
            type = javaType.type(),
        )
    }
}
