@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datalakestore.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Metadata information used by account encryption.
 * @property encryptionKeyName The name of the user managed encryption key.
 * @property encryptionKeyVersion The version of the user managed encryption key.
 * @property keyVaultResourceId The resource identifier for the user managed Key Vault being used to encrypt.
 */
public data class KeyVaultMetaInfoResponse(
    public val encryptionKeyName: String,
    public val encryptionKeyVersion: String,
    public val keyVaultResourceId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datalakestore.outputs.KeyVaultMetaInfoResponse): KeyVaultMetaInfoResponse = KeyVaultMetaInfoResponse(
            encryptionKeyName = javaType.encryptionKeyName(),
            encryptionKeyVersion = javaType.encryptionKeyVersion(),
            keyVaultResourceId = javaType.keyVaultResourceId(),
        )
    }
}
