@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datalakestore.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Data Lake Store trusted identity provider information.
 * @property id The resource identifier.
 * @property idProvider The URL of this trusted identity provider.
 * @property name The resource name.
 * @property type The resource type.
 */
public data class TrustedIdProviderResponse(
    public val id: String,
    public val idProvider: String,
    public val name: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datalakestore.outputs.TrustedIdProviderResponse): TrustedIdProviderResponse = TrustedIdProviderResponse(
            id = javaType.id(),
            idProvider = javaType.idProvider(),
            name = javaType.name(),
            type = javaType.type(),
        )
    }
}
