@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin

import com.pulumi.azurenative.datamigration.kotlin.outputs.ErrorInfoResponse
import com.pulumi.azurenative.datamigration.kotlin.outputs.MongoConnectionInformationResponse
import com.pulumi.azurenative.datamigration.kotlin.outputs.MongoMigrationCollectionResponse
import com.pulumi.azurenative.datamigration.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.datamigration.kotlin.outputs.ErrorInfoResponse.Companion.toKotlin as errorInfoResponseToKotlin
import com.pulumi.azurenative.datamigration.kotlin.outputs.MongoConnectionInformationResponse.Companion.toKotlin as mongoConnectionInformationResponseToKotlin
import com.pulumi.azurenative.datamigration.kotlin.outputs.MongoMigrationCollectionResponse.Companion.toKotlin as mongoMigrationCollectionResponseToKotlin
import com.pulumi.azurenative.datamigration.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [DatabaseMigrationsMongoToCosmosDbvCoreMongo].
 */
@PulumiTagMarker
public class DatabaseMigrationsMongoToCosmosDbvCoreMongoResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DatabaseMigrationsMongoToCosmosDbvCoreMongoArgs =
        DatabaseMigrationsMongoToCosmosDbvCoreMongoArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DatabaseMigrationsMongoToCosmosDbvCoreMongoArgsBuilder.() -> Unit) {
        val builder = DatabaseMigrationsMongoToCosmosDbvCoreMongoArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DatabaseMigrationsMongoToCosmosDbvCoreMongo {
        val builtJavaResource =
            com.pulumi.azurenative.datamigration.DatabaseMigrationsMongoToCosmosDbvCoreMongo(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return DatabaseMigrationsMongoToCosmosDbvCoreMongo(builtJavaResource)
    }
}

/**
 * Database Migration Resource for Mongo to CosmosDb.
 * Azure REST API version: 2023-07-15-preview.
 * ## Example Usage
 * ### Create Mongo to CosmosDb Mongo(vCore) Database Migration resource with Maximum parameters.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var databaseMigrationsMongoToCosmosDbvCoreMongo = new AzureNative.DataMigration.DatabaseMigrationsMongoToCosmosDbvCoreMongo("databaseMigrationsMongoToCosmosDbvCoreMongo", new()
 *     {
 *         CollectionList = new[]
 *         {
 *             new AzureNative.DataMigration.Inputs.MongoMigrationCollectionArgs
 *             {
 *                 SourceCollection = "sourceCol1",
 *                 SourceDatabase = "sourceDb1",
 *                 TargetCollection = "targetCol1",
 *                 TargetDatabase = "targetDb1",
 *             },
 *             new AzureNative.DataMigration.Inputs.MongoMigrationCollectionArgs
 *             {
 *                 SourceCollection = "sourceCol2",
 *                 SourceDatabase = "sourceDb2",
 *                 TargetCollection = "sourceCol2",
 *                 TargetDatabase = "sourceDb2",
 *             },
 *         },
 *         Kind = "MongoToCosmosDbMongo",
 *         MigrationName = "migrationRequest",
 *         MigrationService = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.DataMigration/MigrationServices/testMigrationService",
 *         ResourceGroupName = "testrg",
 *         Scope = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.DocumentDB/mongoClusters/targetCosmosDbClusterName",
 *         SourceMongoConnection = new AzureNative.DataMigration.Inputs.MongoConnectionInformationArgs
 *         {
 *             Host = "abc.mongodb.com",
 *             Password = "placeholder",
 *             Port = 88,
 *             UseSsl = true,
 *             UserName = "abc",
 *         },
 *         TargetMongoConnection = new AzureNative.DataMigration.Inputs.MongoConnectionInformationArgs
 *         {
 *             Host = "xyz.mongocluster.cosmos.azure.com",
 *             Password = "placeholder",
 *             Port = 10255,
 *             UseSsl = true,
 *             UserName = "def",
 *         },
 *         TargetResourceName = "targetCosmosDbClusterName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datamigration/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datamigration.NewDatabaseMigrationsMongoToCosmosDbvCoreMongo(ctx, "databaseMigrationsMongoToCosmosDbvCoreMongo", &datamigration.DatabaseMigrationsMongoToCosmosDbvCoreMongoArgs{
 * 			CollectionList: datamigration.MongoMigrationCollectionArray{
 * 				&datamigration.MongoMigrationCollectionArgs{
 * 					SourceCollection: pulumi.String("sourceCol1"),
 * 					SourceDatabase:   pulumi.String("sourceDb1"),
 * 					TargetCollection: pulumi.String("targetCol1"),
 * 					TargetDatabase:   pulumi.String("targetDb1"),
 * 				},
 * 				&datamigration.MongoMigrationCollectionArgs{
 * 					SourceCollection: pulumi.String("sourceCol2"),
 * 					SourceDatabase:   pulumi.String("sourceDb2"),
 * 					TargetCollection: pulumi.String("sourceCol2"),
 * 					TargetDatabase:   pulumi.String("sourceDb2"),
 * 				},
 * 			},
 * 			Kind:              pulumi.String("MongoToCosmosDbMongo"),
 * 			MigrationName:     pulumi.String("migrationRequest"),
 * 			MigrationService:  pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.DataMigration/MigrationServices/testMigrationService"),
 * 			ResourceGroupName: pulumi.String("testrg"),
 * 			Scope:             pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.DocumentDB/mongoClusters/targetCosmosDbClusterName"),
 * 			SourceMongoConnection: &datamigration.MongoConnectionInformationArgs{
 * 				Host:     pulumi.String("abc.mongodb.com"),
 * 				Password: pulumi.String("placeholder"),
 * 				Port:     pulumi.Int(88),
 * 				UseSsl:   pulumi.Bool(true),
 * 				UserName: pulumi.String("abc"),
 * 			},
 * 			TargetMongoConnection: &datamigration.MongoConnectionInformationArgs{
 * 				Host:     pulumi.String("xyz.mongocluster.cosmos.azure.com"),
 * 				Password: pulumi.String("placeholder"),
 * 				Port:     pulumi.Int(10255),
 * 				UseSsl:   pulumi.Bool(true),
 * 				UserName: pulumi.String("def"),
 * 			},
 * 			TargetResourceName: pulumi.String("targetCosmosDbClusterName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datamigration.DatabaseMigrationsMongoToCosmosDbvCoreMongo;
 * import com.pulumi.azurenative.datamigration.DatabaseMigrationsMongoToCosmosDbvCoreMongoArgs;
 * import com.pulumi.azurenative.datamigration.inputs.MongoMigrationCollectionArgs;
 * import com.pulumi.azurenative.datamigration.inputs.MongoConnectionInformationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var databaseMigrationsMongoToCosmosDbvCoreMongo = new DatabaseMigrationsMongoToCosmosDbvCoreMongo("databaseMigrationsMongoToCosmosDbvCoreMongo", DatabaseMigrationsMongoToCosmosDbvCoreMongoArgs.builder()
 *             .collectionList(
 *                 MongoMigrationCollectionArgs.builder()
 *                     .sourceCollection("sourceCol1")
 *                     .sourceDatabase("sourceDb1")
 *                     .targetCollection("targetCol1")
 *                     .targetDatabase("targetDb1")
 *                     .build(),
 *                 MongoMigrationCollectionArgs.builder()
 *                     .sourceCollection("sourceCol2")
 *                     .sourceDatabase("sourceDb2")
 *                     .targetCollection("sourceCol2")
 *                     .targetDatabase("sourceDb2")
 *                     .build())
 *             .kind("MongoToCosmosDbMongo")
 *             .migrationName("migrationRequest")
 *             .migrationService("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.DataMigration/MigrationServices/testMigrationService")
 *             .resourceGroupName("testrg")
 *             .scope("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.DocumentDB/mongoClusters/targetCosmosDbClusterName")
 *             .sourceMongoConnection(MongoConnectionInformationArgs.builder()
 *                 .host("abc.mongodb.com")
 *                 .password("placeholder")
 *                 .port(88)
 *                 .useSsl(true)
 *                 .userName("abc")
 *                 .build())
 *             .targetMongoConnection(MongoConnectionInformationArgs.builder()
 *                 .host("xyz.mongocluster.cosmos.azure.com")
 *                 .password("placeholder")
 *                 .port(10255)
 *                 .useSsl(true)
 *                 .userName("def")
 *                 .build())
 *             .targetResourceName("targetCosmosDbClusterName")
 *             .build());
 *     }
 * }
 * ```
 * ### Create Mongo to CosmosDb Mongo(vCore) Database Migration resource with Minimum parameters.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var databaseMigrationsMongoToCosmosDbvCoreMongo = new AzureNative.DataMigration.DatabaseMigrationsMongoToCosmosDbvCoreMongo("databaseMigrationsMongoToCosmosDbvCoreMongo", new()
 *     {
 *         CollectionList = new[]
 *         {
 *             new AzureNative.DataMigration.Inputs.MongoMigrationCollectionArgs
 *             {
 *                 SourceCollection = "sourceCol1",
 *                 SourceDatabase = "sourceDb1",
 *                 TargetCollection = "targetCol1",
 *                 TargetDatabase = "targetDb1",
 *             },
 *             new AzureNative.DataMigration.Inputs.MongoMigrationCollectionArgs
 *             {
 *                 SourceCollection = "sourceCol2",
 *                 SourceDatabase = "sourceDb2",
 *             },
 *         },
 *         Kind = "MongoToCosmosDbMongo",
 *         MigrationName = "migrationRequest",
 *         MigrationService = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.DataMigration/MigrationServices/testMigrationService",
 *         ResourceGroupName = "testrg",
 *         Scope = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.DocumentDB/mongoClusters/targetCosmosDbClusterName",
 *         SourceMongoConnection = new AzureNative.DataMigration.Inputs.MongoConnectionInformationArgs
 *         {
 *             Host = "abc.mongodb.com",
 *             Password = "placeholder",
 *             Port = 88,
 *             UseSsl = true,
 *             UserName = "abc",
 *         },
 *         TargetMongoConnection = new AzureNative.DataMigration.Inputs.MongoConnectionInformationArgs
 *         {
 *             ConnectionString = "placeholder",
 *         },
 *         TargetResourceName = "targetCosmosDbClusterName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datamigration/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datamigration.NewDatabaseMigrationsMongoToCosmosDbvCoreMongo(ctx, "databaseMigrationsMongoToCosmosDbvCoreMongo", &datamigration.DatabaseMigrationsMongoToCosmosDbvCoreMongoArgs{
 * 			CollectionList: datamigration.MongoMigrationCollectionArray{
 * 				&datamigration.MongoMigrationCollectionArgs{
 * 					SourceCollection: pulumi.String("sourceCol1"),
 * 					SourceDatabase:   pulumi.String("sourceDb1"),
 * 					TargetCollection: pulumi.String("targetCol1"),
 * 					TargetDatabase:   pulumi.String("targetDb1"),
 * 				},
 * 				&datamigration.MongoMigrationCollectionArgs{
 * 					SourceCollection: pulumi.String("sourceCol2"),
 * 					SourceDatabase:   pulumi.String("sourceDb2"),
 * 				},
 * 			},
 * 			Kind:              pulumi.String("MongoToCosmosDbMongo"),
 * 			MigrationName:     pulumi.String("migrationRequest"),
 * 			MigrationService:  pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.DataMigration/MigrationServices/testMigrationService"),
 * 			ResourceGroupName: pulumi.String("testrg"),
 * 			Scope:             pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.DocumentDB/mongoClusters/targetCosmosDbClusterName"),
 * 			SourceMongoConnection: &datamigration.MongoConnectionInformationArgs{
 * 				Host:     pulumi.String("abc.mongodb.com"),
 * 				Password: pulumi.String("placeholder"),
 * 				Port:     pulumi.Int(88),
 * 				UseSsl:   pulumi.Bool(true),
 * 				UserName: pulumi.String("abc"),
 * 			},
 * 			TargetMongoConnection: &datamigration.MongoConnectionInformationArgs{
 * 				ConnectionString: pulumi.String("placeholder"),
 * 			},
 * 			TargetResourceName: pulumi.String("targetCosmosDbClusterName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datamigration.DatabaseMigrationsMongoToCosmosDbvCoreMongo;
 * import com.pulumi.azurenative.datamigration.DatabaseMigrationsMongoToCosmosDbvCoreMongoArgs;
 * import com.pulumi.azurenative.datamigration.inputs.MongoMigrationCollectionArgs;
 * import com.pulumi.azurenative.datamigration.inputs.MongoConnectionInformationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var databaseMigrationsMongoToCosmosDbvCoreMongo = new DatabaseMigrationsMongoToCosmosDbvCoreMongo("databaseMigrationsMongoToCosmosDbvCoreMongo", DatabaseMigrationsMongoToCosmosDbvCoreMongoArgs.builder()
 *             .collectionList(
 *                 MongoMigrationCollectionArgs.builder()
 *                     .sourceCollection("sourceCol1")
 *                     .sourceDatabase("sourceDb1")
 *                     .targetCollection("targetCol1")
 *                     .targetDatabase("targetDb1")
 *                     .build(),
 *                 MongoMigrationCollectionArgs.builder()
 *                     .sourceCollection("sourceCol2")
 *                     .sourceDatabase("sourceDb2")
 *                     .build())
 *             .kind("MongoToCosmosDbMongo")
 *             .migrationName("migrationRequest")
 *             .migrationService("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.DataMigration/MigrationServices/testMigrationService")
 *             .resourceGroupName("testrg")
 *             .scope("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.DocumentDB/mongoClusters/targetCosmosDbClusterName")
 *             .sourceMongoConnection(MongoConnectionInformationArgs.builder()
 *                 .host("abc.mongodb.com")
 *                 .password("placeholder")
 *                 .port(88)
 *                 .useSsl(true)
 *                 .userName("abc")
 *                 .build())
 *             .targetMongoConnection(MongoConnectionInformationArgs.builder()
 *                 .connectionString("placeholder")
 *                 .build())
 *             .targetResourceName("targetCosmosDbClusterName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:datamigration:DatabaseMigrationsMongoToCosmosDbvCoreMongo migrationRequest /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/mongoClusters/{targetResourceName}/providers/Microsoft.DataMigration/databaseMigrations/{migrationName}
 * ```
 */
public class DatabaseMigrationsMongoToCosmosDbvCoreMongo internal constructor(
    override val javaResource: com.pulumi.azurenative.datamigration.DatabaseMigrationsMongoToCosmosDbvCoreMongo,
) : KotlinCustomResource(javaResource, DatabaseMigrationsMongoToCosmosDbvCoreMongoMapper) {
    /**
     * List of Mongo Collections to be migrated.
     */
    public val collectionList: Output<List<MongoMigrationCollectionResponse>>?
        get() = javaResource.collectionList().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        mongoMigrationCollectionResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Database migration end time.
     */
    public val endedOn: Output<String>
        get() = javaResource.endedOn().applyValue({ args0 -> args0 })

    /**
     *
     * Expected value is 'MongoToCosmosDbMongo'.
     */
    public val kind: Output<String>
        get() = javaResource.kind().applyValue({ args0 -> args0 })

    /**
     * Error details in case of migration failure.
     */
    public val migrationFailureError: Output<ErrorInfoResponse>
        get() = javaResource.migrationFailureError().applyValue({ args0 ->
            args0.let({ args0 ->
                errorInfoResponseToKotlin(args0)
            })
        })

    /**
     * ID for current migration operation.
     */
    public val migrationOperationId: Output<String>?
        get() = javaResource.migrationOperationId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource Id of the Migration Service.
     */
    public val migrationService: Output<String>?
        get() = javaResource.migrationService().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Migration status.
     */
    public val migrationStatus: Output<String>
        get() = javaResource.migrationStatus().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Error message for migration provisioning failure, if any.
     */
    public val provisioningError: Output<String>?
        get() = javaResource.provisioningError().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Provisioning State of migration. ProvisioningState as Succeeded implies that validations have been performed and migration has started.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Resource Id of the target resource.
     */
    public val scope: Output<String>?
        get() = javaResource.scope().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Source Mongo connection details.
     */
    public val sourceMongoConnection: Output<MongoConnectionInformationResponse>?
        get() = javaResource.sourceMongoConnection().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> mongoConnectionInformationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Database migration start time.
     */
    public val startedOn: Output<String>
        get() = javaResource.startedOn().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Target Cosmos DB Mongo connection details.
     */
    public val targetMongoConnection: Output<MongoConnectionInformationResponse>?
        get() = javaResource.targetMongoConnection().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> mongoConnectionInformationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object DatabaseMigrationsMongoToCosmosDbvCoreMongoMapper :
    ResourceMapper<DatabaseMigrationsMongoToCosmosDbvCoreMongo> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.datamigration.DatabaseMigrationsMongoToCosmosDbvCoreMongo::class == javaResource::class

    override fun map(javaResource: Resource): DatabaseMigrationsMongoToCosmosDbvCoreMongo =
        DatabaseMigrationsMongoToCosmosDbvCoreMongo(
            javaResource as
                com.pulumi.azurenative.datamigration.DatabaseMigrationsMongoToCosmosDbvCoreMongo,
        )
}

/**
 * @see [DatabaseMigrationsMongoToCosmosDbvCoreMongo].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DatabaseMigrationsMongoToCosmosDbvCoreMongo].
 */
public suspend fun databaseMigrationsMongoToCosmosDbvCoreMongo(
    name: String,
    block: suspend DatabaseMigrationsMongoToCosmosDbvCoreMongoResourceBuilder.() -> Unit,
): DatabaseMigrationsMongoToCosmosDbvCoreMongo {
    val builder = DatabaseMigrationsMongoToCosmosDbvCoreMongoResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DatabaseMigrationsMongoToCosmosDbvCoreMongo].
 * @param name The _unique_ name of the resulting resource.
 */
public fun databaseMigrationsMongoToCosmosDbvCoreMongo(name: String): DatabaseMigrationsMongoToCosmosDbvCoreMongo {
    val builder = DatabaseMigrationsMongoToCosmosDbvCoreMongoResourceBuilder()
    builder.name(name)
    return builder.build()
}
