@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin

import com.pulumi.azurenative.datamigration.DatamigrationFunctions.getDatabaseMigrationsMongoToCosmosDbRUMongoPlain
import com.pulumi.azurenative.datamigration.DatamigrationFunctions.getDatabaseMigrationsMongoToCosmosDbvCoreMongoPlain
import com.pulumi.azurenative.datamigration.DatamigrationFunctions.getDatabaseMigrationsSqlDbPlain
import com.pulumi.azurenative.datamigration.DatamigrationFunctions.getFilePlain
import com.pulumi.azurenative.datamigration.DatamigrationFunctions.getMigrationServicePlain
import com.pulumi.azurenative.datamigration.DatamigrationFunctions.getProjectPlain
import com.pulumi.azurenative.datamigration.DatamigrationFunctions.getServicePlain
import com.pulumi.azurenative.datamigration.DatamigrationFunctions.getServiceTaskPlain
import com.pulumi.azurenative.datamigration.DatamigrationFunctions.getSqlMigrationServicePlain
import com.pulumi.azurenative.datamigration.DatamigrationFunctions.getTaskPlain
import com.pulumi.azurenative.datamigration.DatamigrationFunctions.listSqlMigrationServiceAuthKeysPlain
import com.pulumi.azurenative.datamigration.DatamigrationFunctions.listSqlMigrationServiceMonitoringDataPlain
import com.pulumi.azurenative.datamigration.kotlin.inputs.GetDatabaseMigrationsMongoToCosmosDbRUMongoPlainArgs
import com.pulumi.azurenative.datamigration.kotlin.inputs.GetDatabaseMigrationsMongoToCosmosDbRUMongoPlainArgsBuilder
import com.pulumi.azurenative.datamigration.kotlin.inputs.GetDatabaseMigrationsMongoToCosmosDbvCoreMongoPlainArgs
import com.pulumi.azurenative.datamigration.kotlin.inputs.GetDatabaseMigrationsMongoToCosmosDbvCoreMongoPlainArgsBuilder
import com.pulumi.azurenative.datamigration.kotlin.inputs.GetDatabaseMigrationsSqlDbPlainArgs
import com.pulumi.azurenative.datamigration.kotlin.inputs.GetDatabaseMigrationsSqlDbPlainArgsBuilder
import com.pulumi.azurenative.datamigration.kotlin.inputs.GetFilePlainArgs
import com.pulumi.azurenative.datamigration.kotlin.inputs.GetFilePlainArgsBuilder
import com.pulumi.azurenative.datamigration.kotlin.inputs.GetMigrationServicePlainArgs
import com.pulumi.azurenative.datamigration.kotlin.inputs.GetMigrationServicePlainArgsBuilder
import com.pulumi.azurenative.datamigration.kotlin.inputs.GetProjectPlainArgs
import com.pulumi.azurenative.datamigration.kotlin.inputs.GetProjectPlainArgsBuilder
import com.pulumi.azurenative.datamigration.kotlin.inputs.GetServicePlainArgs
import com.pulumi.azurenative.datamigration.kotlin.inputs.GetServicePlainArgsBuilder
import com.pulumi.azurenative.datamigration.kotlin.inputs.GetServiceTaskPlainArgs
import com.pulumi.azurenative.datamigration.kotlin.inputs.GetServiceTaskPlainArgsBuilder
import com.pulumi.azurenative.datamigration.kotlin.inputs.GetSqlMigrationServicePlainArgs
import com.pulumi.azurenative.datamigration.kotlin.inputs.GetSqlMigrationServicePlainArgsBuilder
import com.pulumi.azurenative.datamigration.kotlin.inputs.GetTaskPlainArgs
import com.pulumi.azurenative.datamigration.kotlin.inputs.GetTaskPlainArgsBuilder
import com.pulumi.azurenative.datamigration.kotlin.inputs.ListSqlMigrationServiceAuthKeysPlainArgs
import com.pulumi.azurenative.datamigration.kotlin.inputs.ListSqlMigrationServiceAuthKeysPlainArgsBuilder
import com.pulumi.azurenative.datamigration.kotlin.inputs.ListSqlMigrationServiceMonitoringDataPlainArgs
import com.pulumi.azurenative.datamigration.kotlin.inputs.ListSqlMigrationServiceMonitoringDataPlainArgsBuilder
import com.pulumi.azurenative.datamigration.kotlin.outputs.GetDatabaseMigrationsMongoToCosmosDbRUMongoResult
import com.pulumi.azurenative.datamigration.kotlin.outputs.GetDatabaseMigrationsMongoToCosmosDbvCoreMongoResult
import com.pulumi.azurenative.datamigration.kotlin.outputs.GetDatabaseMigrationsSqlDbResult
import com.pulumi.azurenative.datamigration.kotlin.outputs.GetFileResult
import com.pulumi.azurenative.datamigration.kotlin.outputs.GetMigrationServiceResult
import com.pulumi.azurenative.datamigration.kotlin.outputs.GetProjectResult
import com.pulumi.azurenative.datamigration.kotlin.outputs.GetServiceResult
import com.pulumi.azurenative.datamigration.kotlin.outputs.GetServiceTaskResult
import com.pulumi.azurenative.datamigration.kotlin.outputs.GetSqlMigrationServiceResult
import com.pulumi.azurenative.datamigration.kotlin.outputs.GetTaskResult
import com.pulumi.azurenative.datamigration.kotlin.outputs.ListSqlMigrationServiceAuthKeysResult
import com.pulumi.azurenative.datamigration.kotlin.outputs.ListSqlMigrationServiceMonitoringDataResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.datamigration.kotlin.outputs.GetDatabaseMigrationsMongoToCosmosDbRUMongoResult.Companion.toKotlin as getDatabaseMigrationsMongoToCosmosDbRUMongoResultToKotlin
import com.pulumi.azurenative.datamigration.kotlin.outputs.GetDatabaseMigrationsMongoToCosmosDbvCoreMongoResult.Companion.toKotlin as getDatabaseMigrationsMongoToCosmosDbvCoreMongoResultToKotlin
import com.pulumi.azurenative.datamigration.kotlin.outputs.GetDatabaseMigrationsSqlDbResult.Companion.toKotlin as getDatabaseMigrationsSqlDbResultToKotlin
import com.pulumi.azurenative.datamigration.kotlin.outputs.GetFileResult.Companion.toKotlin as getFileResultToKotlin
import com.pulumi.azurenative.datamigration.kotlin.outputs.GetMigrationServiceResult.Companion.toKotlin as getMigrationServiceResultToKotlin
import com.pulumi.azurenative.datamigration.kotlin.outputs.GetProjectResult.Companion.toKotlin as getProjectResultToKotlin
import com.pulumi.azurenative.datamigration.kotlin.outputs.GetServiceResult.Companion.toKotlin as getServiceResultToKotlin
import com.pulumi.azurenative.datamigration.kotlin.outputs.GetServiceTaskResult.Companion.toKotlin as getServiceTaskResultToKotlin
import com.pulumi.azurenative.datamigration.kotlin.outputs.GetSqlMigrationServiceResult.Companion.toKotlin as getSqlMigrationServiceResultToKotlin
import com.pulumi.azurenative.datamigration.kotlin.outputs.GetTaskResult.Companion.toKotlin as getTaskResultToKotlin
import com.pulumi.azurenative.datamigration.kotlin.outputs.ListSqlMigrationServiceAuthKeysResult.Companion.toKotlin as listSqlMigrationServiceAuthKeysResultToKotlin
import com.pulumi.azurenative.datamigration.kotlin.outputs.ListSqlMigrationServiceMonitoringDataResult.Companion.toKotlin as listSqlMigrationServiceMonitoringDataResultToKotlin

public object DatamigrationFunctions {
    /**
     * Get Database Migration resource.
     * Azure REST API version: 2023-07-15-preview.
     * @param argument null
     * @return Database Migration Resource for Mongo to CosmosDb.
     */
    public suspend fun getDatabaseMigrationsMongoToCosmosDbRUMongo(argument: GetDatabaseMigrationsMongoToCosmosDbRUMongoPlainArgs): GetDatabaseMigrationsMongoToCosmosDbRUMongoResult =
        getDatabaseMigrationsMongoToCosmosDbRUMongoResultToKotlin(getDatabaseMigrationsMongoToCosmosDbRUMongoPlain(argument.toJava()).await())

    /**
     * @see [getDatabaseMigrationsMongoToCosmosDbRUMongo].
     * @param migrationName Name of the migration.
     * @param resourceGroupName Name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param targetResourceName The name of the target resource/account.
     * @return Database Migration Resource for Mongo to CosmosDb.
     */
    public suspend fun getDatabaseMigrationsMongoToCosmosDbRUMongo(
        migrationName: String,
        resourceGroupName: String,
        targetResourceName: String,
    ): GetDatabaseMigrationsMongoToCosmosDbRUMongoResult {
        val argument = GetDatabaseMigrationsMongoToCosmosDbRUMongoPlainArgs(
            migrationName = migrationName,
            resourceGroupName = resourceGroupName,
            targetResourceName = targetResourceName,
        )
        return getDatabaseMigrationsMongoToCosmosDbRUMongoResultToKotlin(getDatabaseMigrationsMongoToCosmosDbRUMongoPlain(argument.toJava()).await())
    }

    /**
     * @see [getDatabaseMigrationsMongoToCosmosDbRUMongo].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;datamigration&#46;kotlin&#46;inputs&#46;GetDatabaseMigrationsMongoToCosmosDbRUMongoPlainArgs].
     * @return Database Migration Resource for Mongo to CosmosDb.
     */
    public suspend fun getDatabaseMigrationsMongoToCosmosDbRUMongo(argument: suspend GetDatabaseMigrationsMongoToCosmosDbRUMongoPlainArgsBuilder.() -> Unit): GetDatabaseMigrationsMongoToCosmosDbRUMongoResult {
        val builder = GetDatabaseMigrationsMongoToCosmosDbRUMongoPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDatabaseMigrationsMongoToCosmosDbRUMongoResultToKotlin(getDatabaseMigrationsMongoToCosmosDbRUMongoPlain(builtArgument.toJava()).await())
    }

    /**
     * Get Database Migration resource.
     * Azure REST API version: 2023-07-15-preview.
     * @param argument null
     * @return Database Migration Resource for Mongo to CosmosDb.
     */
    public suspend fun getDatabaseMigrationsMongoToCosmosDbvCoreMongo(argument: GetDatabaseMigrationsMongoToCosmosDbvCoreMongoPlainArgs): GetDatabaseMigrationsMongoToCosmosDbvCoreMongoResult =
        getDatabaseMigrationsMongoToCosmosDbvCoreMongoResultToKotlin(getDatabaseMigrationsMongoToCosmosDbvCoreMongoPlain(argument.toJava()).await())

    /**
     * @see [getDatabaseMigrationsMongoToCosmosDbvCoreMongo].
     * @param migrationName Name of the migration.
     * @param resourceGroupName Name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param targetResourceName The name of the target resource/account.
     * @return Database Migration Resource for Mongo to CosmosDb.
     */
    public suspend fun getDatabaseMigrationsMongoToCosmosDbvCoreMongo(
        migrationName: String,
        resourceGroupName: String,
        targetResourceName: String,
    ): GetDatabaseMigrationsMongoToCosmosDbvCoreMongoResult {
        val argument = GetDatabaseMigrationsMongoToCosmosDbvCoreMongoPlainArgs(
            migrationName = migrationName,
            resourceGroupName = resourceGroupName,
            targetResourceName = targetResourceName,
        )
        return getDatabaseMigrationsMongoToCosmosDbvCoreMongoResultToKotlin(getDatabaseMigrationsMongoToCosmosDbvCoreMongoPlain(argument.toJava()).await())
    }

    /**
     * @see [getDatabaseMigrationsMongoToCosmosDbvCoreMongo].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;datamigration&#46;kotlin&#46;inputs&#46;GetDatabaseMigrationsMongoToCosmosDbvCoreMongoPlainArgs].
     * @return Database Migration Resource for Mongo to CosmosDb.
     */
    public suspend fun getDatabaseMigrationsMongoToCosmosDbvCoreMongo(argument: suspend GetDatabaseMigrationsMongoToCosmosDbvCoreMongoPlainArgsBuilder.() -> Unit): GetDatabaseMigrationsMongoToCosmosDbvCoreMongoResult {
        val builder = GetDatabaseMigrationsMongoToCosmosDbvCoreMongoPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDatabaseMigrationsMongoToCosmosDbvCoreMongoResultToKotlin(getDatabaseMigrationsMongoToCosmosDbvCoreMongoPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieve the Database Migration resource.
     * Azure REST API version: 2022-03-30-preview.
     * Other available API versions: 2023-07-15-preview.
     * @param argument null
     * @return Database Migration Resource for SQL Database.
     */
    public suspend fun getDatabaseMigrationsSqlDb(argument: GetDatabaseMigrationsSqlDbPlainArgs): GetDatabaseMigrationsSqlDbResult =
        getDatabaseMigrationsSqlDbResultToKotlin(getDatabaseMigrationsSqlDbPlain(argument.toJava()).await())

    /**
     * @see [getDatabaseMigrationsSqlDb].
     * @param expand Complete migration details be included in the response.
     * @param migrationOperationId Optional migration operation ID. If this is provided, then details of migration operation for that ID are retrieved. If not provided (default), then details related to most recent or current operation are retrieved.
     * @param resourceGroupName Name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param sqlDbInstanceName
     * @param targetDbName The name of the target database.
     * @return Database Migration Resource for SQL Database.
     */
    public suspend fun getDatabaseMigrationsSqlDb(
        expand: String? = null,
        migrationOperationId: String? = null,
        resourceGroupName: String,
        sqlDbInstanceName: String,
        targetDbName: String,
    ): GetDatabaseMigrationsSqlDbResult {
        val argument = GetDatabaseMigrationsSqlDbPlainArgs(
            expand = expand,
            migrationOperationId = migrationOperationId,
            resourceGroupName = resourceGroupName,
            sqlDbInstanceName = sqlDbInstanceName,
            targetDbName = targetDbName,
        )
        return getDatabaseMigrationsSqlDbResultToKotlin(getDatabaseMigrationsSqlDbPlain(argument.toJava()).await())
    }

    /**
     * @see [getDatabaseMigrationsSqlDb].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;datamigration&#46;kotlin&#46;inputs&#46;GetDatabaseMigrationsSqlDbPlainArgs].
     * @return Database Migration Resource for SQL Database.
     */
    public suspend fun getDatabaseMigrationsSqlDb(argument: suspend GetDatabaseMigrationsSqlDbPlainArgsBuilder.() -> Unit): GetDatabaseMigrationsSqlDbResult {
        val builder = GetDatabaseMigrationsSqlDbPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDatabaseMigrationsSqlDbResultToKotlin(getDatabaseMigrationsSqlDbPlain(builtArgument.toJava()).await())
    }

    /**
     * The files resource is a nested, proxy-only resource representing a file stored under the project resource. This method retrieves information about a file.
     * Azure REST API version: 2021-06-30.
     * Other available API versions: 2022-03-30-preview, 2023-07-15-preview.
     * @param argument null
     * @return A file resource
     */
    public suspend fun getFile(argument: GetFilePlainArgs): GetFileResult =
        getFileResultToKotlin(getFilePlain(argument.toJava()).await())

    /**
     * @see [getFile].
     * @param fileName Name of the File
     * @param groupName Name of the resource group
     * @param projectName Name of the project
     * @param serviceName Name of the service
     * @return A file resource
     */
    public suspend fun getFile(
        fileName: String,
        groupName: String,
        projectName: String,
        serviceName: String,
    ): GetFileResult {
        val argument = GetFilePlainArgs(
            fileName = fileName,
            groupName = groupName,
            projectName = projectName,
            serviceName = serviceName,
        )
        return getFileResultToKotlin(getFilePlain(argument.toJava()).await())
    }

    /**
     * @see [getFile].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;datamigration&#46;kotlin&#46;inputs&#46;GetFilePlainArgs].
     * @return A file resource
     */
    public suspend fun getFile(argument: suspend GetFilePlainArgsBuilder.() -> Unit): GetFileResult {
        val builder = GetFilePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getFileResultToKotlin(getFilePlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieve the Database Migration Service
     * Azure REST API version: 2023-07-15-preview.
     * @param argument null
     * @return A Migration Service.
     */
    public suspend fun getMigrationService(argument: GetMigrationServicePlainArgs): GetMigrationServiceResult =
        getMigrationServiceResultToKotlin(getMigrationServicePlain(argument.toJava()).await())

    /**
     * @see [getMigrationService].
     * @param migrationServiceName Name of the Migration Service.
     * @param resourceGroupName Name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @return A Migration Service.
     */
    public suspend fun getMigrationService(migrationServiceName: String, resourceGroupName: String): GetMigrationServiceResult {
        val argument = GetMigrationServicePlainArgs(
            migrationServiceName = migrationServiceName,
            resourceGroupName = resourceGroupName,
        )
        return getMigrationServiceResultToKotlin(getMigrationServicePlain(argument.toJava()).await())
    }

    /**
     * @see [getMigrationService].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;datamigration&#46;kotlin&#46;inputs&#46;GetMigrationServicePlainArgs].
     * @return A Migration Service.
     */
    public suspend fun getMigrationService(argument: suspend GetMigrationServicePlainArgsBuilder.() -> Unit): GetMigrationServiceResult {
        val builder = GetMigrationServicePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getMigrationServiceResultToKotlin(getMigrationServicePlain(builtArgument.toJava()).await())
    }

    /**
     * The project resource is a nested resource representing a stored migration project. The GET method retrieves information about a project.
     * Azure REST API version: 2021-06-30.
     * Other available API versions: 2017-11-15-preview, 2018-03-31-preview, 2021-10-30-preview, 2022-03-30-preview, 2023-07-15-preview.
     * @param argument null
     * @return A project resource
     */
    public suspend fun getProject(argument: GetProjectPlainArgs): GetProjectResult =
        getProjectResultToKotlin(getProjectPlain(argument.toJava()).await())

    /**
     * @see [getProject].
     * @param groupName Name of the resource group
     * @param projectName Name of the project
     * @param serviceName Name of the service
     * @return A project resource
     */
    public suspend fun getProject(
        groupName: String,
        projectName: String,
        serviceName: String,
    ): GetProjectResult {
        val argument = GetProjectPlainArgs(
            groupName = groupName,
            projectName = projectName,
            serviceName = serviceName,
        )
        return getProjectResultToKotlin(getProjectPlain(argument.toJava()).await())
    }

    /**
     * @see [getProject].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;datamigration&#46;kotlin&#46;inputs&#46;GetProjectPlainArgs].
     * @return A project resource
     */
    public suspend fun getProject(argument: suspend GetProjectPlainArgsBuilder.() -> Unit): GetProjectResult {
        val builder = GetProjectPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getProjectResultToKotlin(getProjectPlain(builtArgument.toJava()).await())
    }

    /**
     * The services resource is the top-level resource that represents the Database Migration Service. The GET method retrieves information about a service instance.
     * Azure REST API version: 2021-06-30.
     * Other available API versions: 2022-03-30-preview, 2023-07-15-preview.
     * @param argument null
     * @return A Database Migration Service resource
     */
    public suspend fun getService(argument: GetServicePlainArgs): GetServiceResult =
        getServiceResultToKotlin(getServicePlain(argument.toJava()).await())

    /**
     * @see [getService].
     * @param groupName Name of the resource group
     * @param serviceName Name of the service
     * @return A Database Migration Service resource
     */
    public suspend fun getService(groupName: String, serviceName: String): GetServiceResult {
        val argument = GetServicePlainArgs(
            groupName = groupName,
            serviceName = serviceName,
        )
        return getServiceResultToKotlin(getServicePlain(argument.toJava()).await())
    }

    /**
     * @see [getService].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;datamigration&#46;kotlin&#46;inputs&#46;GetServicePlainArgs].
     * @return A Database Migration Service resource
     */
    public suspend fun getService(argument: suspend GetServicePlainArgsBuilder.() -> Unit): GetServiceResult {
        val builder = GetServicePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServiceResultToKotlin(getServicePlain(builtArgument.toJava()).await())
    }

    /**
     * The service tasks resource is a nested, proxy-only resource representing work performed by a DMS instance. The GET method retrieves information about a service task.
     * Azure REST API version: 2021-06-30.
     * Other available API versions: 2022-03-30-preview, 2023-07-15-preview.
     * @param argument null
     * @return A task resource
     */
    public suspend fun getServiceTask(argument: GetServiceTaskPlainArgs): GetServiceTaskResult =
        getServiceTaskResultToKotlin(getServiceTaskPlain(argument.toJava()).await())

    /**
     * @see [getServiceTask].
     * @param expand Expand the response
     * @param groupName Name of the resource group
     * @param serviceName Name of the service
     * @param taskName Name of the Task
     * @return A task resource
     */
    public suspend fun getServiceTask(
        expand: String? = null,
        groupName: String,
        serviceName: String,
        taskName: String,
    ): GetServiceTaskResult {
        val argument = GetServiceTaskPlainArgs(
            expand = expand,
            groupName = groupName,
            serviceName = serviceName,
            taskName = taskName,
        )
        return getServiceTaskResultToKotlin(getServiceTaskPlain(argument.toJava()).await())
    }

    /**
     * @see [getServiceTask].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;datamigration&#46;kotlin&#46;inputs&#46;GetServiceTaskPlainArgs].
     * @return A task resource
     */
    public suspend fun getServiceTask(argument: suspend GetServiceTaskPlainArgsBuilder.() -> Unit): GetServiceTaskResult {
        val builder = GetServiceTaskPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServiceTaskResultToKotlin(getServiceTaskPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieve the Database Migration Service
     * Azure REST API version: 2022-03-30-preview.
     * Other available API versions: 2023-07-15-preview.
     * @param argument null
     * @return A SQL Migration Service.
     */
    public suspend fun getSqlMigrationService(argument: GetSqlMigrationServicePlainArgs): GetSqlMigrationServiceResult =
        getSqlMigrationServiceResultToKotlin(getSqlMigrationServicePlain(argument.toJava()).await())

    /**
     * @see [getSqlMigrationService].
     * @param resourceGroupName Name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param sqlMigrationServiceName Name of the SQL Migration Service.
     * @return A SQL Migration Service.
     */
    public suspend fun getSqlMigrationService(
        resourceGroupName: String,
        sqlMigrationServiceName: String,
    ): GetSqlMigrationServiceResult {
        val argument = GetSqlMigrationServicePlainArgs(
            resourceGroupName = resourceGroupName,
            sqlMigrationServiceName = sqlMigrationServiceName,
        )
        return getSqlMigrationServiceResultToKotlin(getSqlMigrationServicePlain(argument.toJava()).await())
    }

    /**
     * @see [getSqlMigrationService].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;datamigration&#46;kotlin&#46;inputs&#46;GetSqlMigrationServicePlainArgs].
     * @return A SQL Migration Service.
     */
    public suspend fun getSqlMigrationService(argument: suspend GetSqlMigrationServicePlainArgsBuilder.() -> Unit): GetSqlMigrationServiceResult {
        val builder = GetSqlMigrationServicePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSqlMigrationServiceResultToKotlin(getSqlMigrationServicePlain(builtArgument.toJava()).await())
    }

    /**
     * The tasks resource is a nested, proxy-only resource representing work performed by a DMS instance. The GET method retrieves information about a task.
     * Azure REST API version: 2021-06-30.
     * Other available API versions: 2022-03-30-preview, 2023-07-15-preview.
     * @param argument null
     * @return A task resource
     */
    public suspend fun getTask(argument: GetTaskPlainArgs): GetTaskResult =
        getTaskResultToKotlin(getTaskPlain(argument.toJava()).await())

    /**
     * @see [getTask].
     * @param expand Expand the response
     * @param groupName Name of the resource group
     * @param projectName Name of the project
     * @param serviceName Name of the service
     * @param taskName Name of the Task
     * @return A task resource
     */
    public suspend fun getTask(
        expand: String? = null,
        groupName: String,
        projectName: String,
        serviceName: String,
        taskName: String,
    ): GetTaskResult {
        val argument = GetTaskPlainArgs(
            expand = expand,
            groupName = groupName,
            projectName = projectName,
            serviceName = serviceName,
            taskName = taskName,
        )
        return getTaskResultToKotlin(getTaskPlain(argument.toJava()).await())
    }

    /**
     * @see [getTask].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;datamigration&#46;kotlin&#46;inputs&#46;GetTaskPlainArgs].
     * @return A task resource
     */
    public suspend fun getTask(argument: suspend GetTaskPlainArgsBuilder.() -> Unit): GetTaskResult {
        val builder = GetTaskPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTaskResultToKotlin(getTaskPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieve the List of Authentication Keys for Self Hosted Integration Runtime.
     * Azure REST API version: 2022-03-30-preview.
     * Other available API versions: 2023-07-15-preview.
     * @param argument null
     * @return An authentication key.
     */
    public suspend fun listSqlMigrationServiceAuthKeys(argument: ListSqlMigrationServiceAuthKeysPlainArgs): ListSqlMigrationServiceAuthKeysResult =
        listSqlMigrationServiceAuthKeysResultToKotlin(listSqlMigrationServiceAuthKeysPlain(argument.toJava()).await())

    /**
     * @see [listSqlMigrationServiceAuthKeys].
     * @param resourceGroupName Name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param sqlMigrationServiceName Name of the SQL Migration Service.
     * @return An authentication key.
     */
    public suspend fun listSqlMigrationServiceAuthKeys(
        resourceGroupName: String,
        sqlMigrationServiceName: String,
    ): ListSqlMigrationServiceAuthKeysResult {
        val argument = ListSqlMigrationServiceAuthKeysPlainArgs(
            resourceGroupName = resourceGroupName,
            sqlMigrationServiceName = sqlMigrationServiceName,
        )
        return listSqlMigrationServiceAuthKeysResultToKotlin(listSqlMigrationServiceAuthKeysPlain(argument.toJava()).await())
    }

    /**
     * @see [listSqlMigrationServiceAuthKeys].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;datamigration&#46;kotlin&#46;inputs&#46;ListSqlMigrationServiceAuthKeysPlainArgs].
     * @return An authentication key.
     */
    public suspend fun listSqlMigrationServiceAuthKeys(argument: suspend ListSqlMigrationServiceAuthKeysPlainArgsBuilder.() -> Unit): ListSqlMigrationServiceAuthKeysResult {
        val builder = ListSqlMigrationServiceAuthKeysPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listSqlMigrationServiceAuthKeysResultToKotlin(listSqlMigrationServiceAuthKeysPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieve the registered Integration Runtime nodes and their monitoring data for a given Database Migration Service.
     * Azure REST API version: 2022-03-30-preview.
     * Other available API versions: 2023-07-15-preview.
     * @param argument null
     * @return Integration Runtime Monitoring Data.
     */
    public suspend fun listSqlMigrationServiceMonitoringData(argument: ListSqlMigrationServiceMonitoringDataPlainArgs): ListSqlMigrationServiceMonitoringDataResult =
        listSqlMigrationServiceMonitoringDataResultToKotlin(listSqlMigrationServiceMonitoringDataPlain(argument.toJava()).await())

    /**
     * @see [listSqlMigrationServiceMonitoringData].
     * @param resourceGroupName Name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param sqlMigrationServiceName Name of the SQL Migration Service.
     * @return Integration Runtime Monitoring Data.
     */
    public suspend fun listSqlMigrationServiceMonitoringData(
        resourceGroupName: String,
        sqlMigrationServiceName: String,
    ): ListSqlMigrationServiceMonitoringDataResult {
        val argument = ListSqlMigrationServiceMonitoringDataPlainArgs(
            resourceGroupName = resourceGroupName,
            sqlMigrationServiceName = sqlMigrationServiceName,
        )
        return listSqlMigrationServiceMonitoringDataResultToKotlin(listSqlMigrationServiceMonitoringDataPlain(argument.toJava()).await())
    }

    /**
     * @see [listSqlMigrationServiceMonitoringData].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;datamigration&#46;kotlin&#46;inputs&#46;ListSqlMigrationServiceMonitoringDataPlainArgs].
     * @return Integration Runtime Monitoring Data.
     */
    public suspend fun listSqlMigrationServiceMonitoringData(argument: suspend ListSqlMigrationServiceMonitoringDataPlainArgsBuilder.() -> Unit): ListSqlMigrationServiceMonitoringDataResult {
        val builder = ListSqlMigrationServiceMonitoringDataPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listSqlMigrationServiceMonitoringDataResultToKotlin(listSqlMigrationServiceMonitoringDataPlain(builtArgument.toJava()).await())
    }
}
