@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin

import com.pulumi.azurenative.datamigration.ServiceArgs.builder
import com.pulumi.azurenative.datamigration.kotlin.inputs.ServiceSkuArgs
import com.pulumi.azurenative.datamigration.kotlin.inputs.ServiceSkuArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A Database Migration Service resource
 * Azure REST API version: 2021-06-30. Prior API version in Azure Native 1.x: 2018-04-19.
 * Other available API versions: 2022-03-30-preview, 2023-07-15-preview.
 * ## Example Usage
 * ### Services_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var service = new AzureNative.DataMigration.Service("service", new()
 *     {
 *         GroupName = "DmsSdkRg",
 *         Location = "southcentralus",
 *         ServiceName = "DmsSdkService",
 *         Sku = new AzureNative.DataMigration.Inputs.ServiceSkuArgs
 *         {
 *             Name = "Basic_1vCore",
 *         },
 *         VirtualSubnetId = "/subscriptions/fc04246f-04c5-437e-ac5e-206a19e7193f/resourceGroups/DmsSdkTestNetwork/providers/Microsoft.Network/virtualNetworks/DmsSdkTestNetwork/subnets/default",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datamigration/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datamigration.NewService(ctx, "service", &datamigration.ServiceArgs{
 * 			GroupName:   pulumi.String("DmsSdkRg"),
 * 			Location:    pulumi.String("southcentralus"),
 * 			ServiceName: pulumi.String("DmsSdkService"),
 * 			Sku: &datamigration.ServiceSkuArgs{
 * 				Name: pulumi.String("Basic_1vCore"),
 * 			},
 * 			VirtualSubnetId: pulumi.String("/subscriptions/fc04246f-04c5-437e-ac5e-206a19e7193f/resourceGroups/DmsSdkTestNetwork/providers/Microsoft.Network/virtualNetworks/DmsSdkTestNetwork/subnets/default"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datamigration.Service;
 * import com.pulumi.azurenative.datamigration.ServiceArgs;
 * import com.pulumi.azurenative.datamigration.inputs.ServiceSkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var service = new Service("service", ServiceArgs.builder()
 *             .groupName("DmsSdkRg")
 *             .location("southcentralus")
 *             .serviceName("DmsSdkService")
 *             .sku(ServiceSkuArgs.builder()
 *                 .name("Basic_1vCore")
 *                 .build())
 *             .virtualSubnetId("/subscriptions/fc04246f-04c5-437e-ac5e-206a19e7193f/resourceGroups/DmsSdkTestNetwork/providers/Microsoft.Network/virtualNetworks/DmsSdkTestNetwork/subnets/default")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:datamigration:Service DmsSdkService /subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.DataMigration/services/{serviceName}
 * ```
 * @property groupName Name of the resource group
 * @property kind The resource kind. Only 'vm' (the default) is supported.
 * @property location Resource location.
 * @property publicKey The public key of the service, used to encrypt secrets sent to the service
 * @property serviceName Name of the service
 * @property sku Service SKU
 * @property tags Resource tags.
 * @property virtualNicId The ID of the Microsoft.Network/networkInterfaces resource which the service have
 * @property virtualSubnetId The ID of the Microsoft.Network/virtualNetworks/subnets resource to which the service should be joined
 */
public data class ServiceArgs(
    public val groupName: Output<String>? = null,
    public val kind: Output<String>? = null,
    public val location: Output<String>? = null,
    public val publicKey: Output<String>? = null,
    public val serviceName: Output<String>? = null,
    public val sku: Output<ServiceSkuArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val virtualNicId: Output<String>? = null,
    public val virtualSubnetId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datamigration.ServiceArgs> {
    override fun toJava(): com.pulumi.azurenative.datamigration.ServiceArgs =
        com.pulumi.azurenative.datamigration.ServiceArgs.builder()
            .groupName(groupName?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .publicKey(publicKey?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .virtualNicId(virtualNicId?.applyValue({ args0 -> args0 }))
            .virtualSubnetId(virtualSubnetId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceArgs].
 */
@PulumiTagMarker
public class ServiceArgsBuilder internal constructor() {
    private var groupName: Output<String>? = null

    private var kind: Output<String>? = null

    private var location: Output<String>? = null

    private var publicKey: Output<String>? = null

    private var serviceName: Output<String>? = null

    private var sku: Output<ServiceSkuArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var virtualNicId: Output<String>? = null

    private var virtualSubnetId: Output<String>? = null

    /**
     * @param value Name of the resource group
     */
    @JvmName("cutorgtdyfprftuj")
    public suspend fun groupName(`value`: Output<String>) {
        this.groupName = value
    }

    /**
     * @param value The resource kind. Only 'vm' (the default) is supported.
     */
    @JvmName("gfeqcnedosihesln")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("igusxlvvoujnijxd")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The public key of the service, used to encrypt secrets sent to the service
     */
    @JvmName("naiiapfhkaibihrj")
    public suspend fun publicKey(`value`: Output<String>) {
        this.publicKey = value
    }

    /**
     * @param value Name of the service
     */
    @JvmName("dwjtdxlapfanrfvk")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value Service SKU
     */
    @JvmName("jhgqarqftllpbwhg")
    public suspend fun sku(`value`: Output<ServiceSkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("mrxvhahysborfrum")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The ID of the Microsoft.Network/networkInterfaces resource which the service have
     */
    @JvmName("xhkxafjagpgybpnw")
    public suspend fun virtualNicId(`value`: Output<String>) {
        this.virtualNicId = value
    }

    /**
     * @param value The ID of the Microsoft.Network/virtualNetworks/subnets resource to which the service should be joined
     */
    @JvmName("jkjymblovaedcjpq")
    public suspend fun virtualSubnetId(`value`: Output<String>) {
        this.virtualSubnetId = value
    }

    /**
     * @param value Name of the resource group
     */
    @JvmName("jkmaldkorkaepfui")
    public suspend fun groupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupName = mapped
    }

    /**
     * @param value The resource kind. Only 'vm' (the default) is supported.
     */
    @JvmName("gkiraymvcuhahdyy")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("wlmaybiplhnncpfn")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The public key of the service, used to encrypt secrets sent to the service
     */
    @JvmName("ovryosjwwhuhcysp")
    public suspend fun publicKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicKey = mapped
    }

    /**
     * @param value Name of the service
     */
    @JvmName("atvmjjcxufyqtnje")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    /**
     * @param value Service SKU
     */
    @JvmName("ufkguyxklfckgfoj")
    public suspend fun sku(`value`: ServiceSkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument Service SKU
     */
    @JvmName("ryvappbhqgnhaajk")
    public suspend fun sku(argument: suspend ServiceSkuArgsBuilder.() -> Unit) {
        val toBeMapped = ServiceSkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("icyrlevdcdwmkriy")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("jadlqxuiwqujrbqe")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The ID of the Microsoft.Network/networkInterfaces resource which the service have
     */
    @JvmName("bohmwlkauwoloppd")
    public suspend fun virtualNicId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualNicId = mapped
    }

    /**
     * @param value The ID of the Microsoft.Network/virtualNetworks/subnets resource to which the service should be joined
     */
    @JvmName("nymehtotffmiuqsk")
    public suspend fun virtualSubnetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualSubnetId = mapped
    }

    internal fun build(): ServiceArgs = ServiceArgs(
        groupName = groupName,
        kind = kind,
        location = location,
        publicKey = publicKey,
        serviceName = serviceName,
        sku = sku,
        tags = tags,
        virtualNicId = virtualNicId,
        virtualSubnetId = virtualSubnetId,
    )
}
