@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin

import com.pulumi.azurenative.datamigration.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.datamigration.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [SqlMigrationService].
 */
@PulumiTagMarker
public class SqlMigrationServiceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SqlMigrationServiceArgs = SqlMigrationServiceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SqlMigrationServiceArgsBuilder.() -> Unit) {
        val builder = SqlMigrationServiceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SqlMigrationService {
        val builtJavaResource =
            com.pulumi.azurenative.datamigration.SqlMigrationService(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return SqlMigrationService(builtJavaResource)
    }
}

/**
 * A SQL Migration Service.
 * Azure REST API version: 2022-03-30-preview. Prior API version in Azure Native 1.x: 2021-10-30-preview.
 * Other available API versions: 2023-07-15-preview.
 * ## Example Usage
 * ### Create or Update SQL Migration Service with maximum parameters.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sqlMigrationService = new AzureNative.DataMigration.SqlMigrationService("sqlMigrationService", new()
 *     {
 *         Location = "northeurope",
 *         ResourceGroupName = "testrg",
 *         SqlMigrationServiceName = "testagent",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datamigration/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datamigration.NewSqlMigrationService(ctx, "sqlMigrationService", &datamigration.SqlMigrationServiceArgs{
 * 			Location:                pulumi.String("northeurope"),
 * 			ResourceGroupName:       pulumi.String("testrg"),
 * 			SqlMigrationServiceName: pulumi.String("testagent"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datamigration.SqlMigrationService;
 * import com.pulumi.azurenative.datamigration.SqlMigrationServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlMigrationService = new SqlMigrationService("sqlMigrationService", SqlMigrationServiceArgs.builder()
 *             .location("northeurope")
 *             .resourceGroupName("testrg")
 *             .sqlMigrationServiceName("testagent")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or Update SQL Migration Service with minimum parameters.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sqlMigrationService = new AzureNative.DataMigration.SqlMigrationService("sqlMigrationService", new()
 *     {
 *         Location = "northeurope",
 *         ResourceGroupName = "testrg",
 *         SqlMigrationServiceName = "testagent",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datamigration/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datamigration.NewSqlMigrationService(ctx, "sqlMigrationService", &datamigration.SqlMigrationServiceArgs{
 * 			Location:                pulumi.String("northeurope"),
 * 			ResourceGroupName:       pulumi.String("testrg"),
 * 			SqlMigrationServiceName: pulumi.String("testagent"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datamigration.SqlMigrationService;
 * import com.pulumi.azurenative.datamigration.SqlMigrationServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlMigrationService = new SqlMigrationService("sqlMigrationService", SqlMigrationServiceArgs.builder()
 *             .location("northeurope")
 *             .resourceGroupName("testrg")
 *             .sqlMigrationServiceName("testagent")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:datamigration:SqlMigrationService testagent /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataMigration/sqlMigrationServices/{sqlMigrationServiceName}
 * ```
 */
public class SqlMigrationService internal constructor(
    override val javaResource: com.pulumi.azurenative.datamigration.SqlMigrationService,
) : KotlinCustomResource(javaResource, SqlMigrationServiceMapper) {
    /**
     * Current state of the Integration runtime.
     */
    public val integrationRuntimeState: Output<String>
        get() = javaResource.integrationRuntimeState().applyValue({ args0 -> args0 })

    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Provisioning state to track the async operation status.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object SqlMigrationServiceMapper : ResourceMapper<SqlMigrationService> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.datamigration.SqlMigrationService::class == javaResource::class

    override fun map(javaResource: Resource): SqlMigrationService = SqlMigrationService(
        javaResource
            as com.pulumi.azurenative.datamigration.SqlMigrationService,
    )
}

/**
 * @see [SqlMigrationService].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SqlMigrationService].
 */
public suspend fun sqlMigrationService(
    name: String,
    block: suspend SqlMigrationServiceResourceBuilder.() -> Unit,
): SqlMigrationService {
    val builder = SqlMigrationServiceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SqlMigrationService].
 * @param name The _unique_ name of the resulting resource.
 */
public fun sqlMigrationService(name: String): SqlMigrationService {
    val builder = SqlMigrationServiceResourceBuilder()
    builder.name(name)
    return builder.build()
}
