@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin

import com.pulumi.azurenative.datamigration.SqlMigrationServiceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A SQL Migration Service.
 * Azure REST API version: 2022-03-30-preview. Prior API version in Azure Native 1.x: 2021-10-30-preview.
 * Other available API versions: 2023-07-15-preview.
 * ## Example Usage
 * ### Create or Update SQL Migration Service with maximum parameters.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sqlMigrationService = new AzureNative.DataMigration.SqlMigrationService("sqlMigrationService", new()
 *     {
 *         Location = "northeurope",
 *         ResourceGroupName = "testrg",
 *         SqlMigrationServiceName = "testagent",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datamigration/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datamigration.NewSqlMigrationService(ctx, "sqlMigrationService", &datamigration.SqlMigrationServiceArgs{
 * 			Location:                pulumi.String("northeurope"),
 * 			ResourceGroupName:       pulumi.String("testrg"),
 * 			SqlMigrationServiceName: pulumi.String("testagent"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datamigration.SqlMigrationService;
 * import com.pulumi.azurenative.datamigration.SqlMigrationServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlMigrationService = new SqlMigrationService("sqlMigrationService", SqlMigrationServiceArgs.builder()
 *             .location("northeurope")
 *             .resourceGroupName("testrg")
 *             .sqlMigrationServiceName("testagent")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or Update SQL Migration Service with minimum parameters.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sqlMigrationService = new AzureNative.DataMigration.SqlMigrationService("sqlMigrationService", new()
 *     {
 *         Location = "northeurope",
 *         ResourceGroupName = "testrg",
 *         SqlMigrationServiceName = "testagent",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datamigration/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datamigration.NewSqlMigrationService(ctx, "sqlMigrationService", &datamigration.SqlMigrationServiceArgs{
 * 			Location:                pulumi.String("northeurope"),
 * 			ResourceGroupName:       pulumi.String("testrg"),
 * 			SqlMigrationServiceName: pulumi.String("testagent"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datamigration.SqlMigrationService;
 * import com.pulumi.azurenative.datamigration.SqlMigrationServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlMigrationService = new SqlMigrationService("sqlMigrationService", SqlMigrationServiceArgs.builder()
 *             .location("northeurope")
 *             .resourceGroupName("testrg")
 *             .sqlMigrationServiceName("testagent")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:datamigration:SqlMigrationService testagent /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataMigration/sqlMigrationServices/{sqlMigrationServiceName}
 * ```
 * @property location
 * @property resourceGroupName Name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property sqlMigrationServiceName Name of the SQL Migration Service.
 * @property tags
 */
public data class SqlMigrationServiceArgs(
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sqlMigrationServiceName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datamigration.SqlMigrationServiceArgs> {
    override fun toJava(): com.pulumi.azurenative.datamigration.SqlMigrationServiceArgs =
        com.pulumi.azurenative.datamigration.SqlMigrationServiceArgs.builder()
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sqlMigrationServiceName(sqlMigrationServiceName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [SqlMigrationServiceArgs].
 */
@PulumiTagMarker
public class SqlMigrationServiceArgsBuilder internal constructor() {
    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var sqlMigrationServiceName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value
     */
    @JvmName("aqejdojbrlejomak")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("jfimnykyvlaxuxfn")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Name of the SQL Migration Service.
     */
    @JvmName("mrxshypcmxgrpmyp")
    public suspend fun sqlMigrationServiceName(`value`: Output<String>) {
        this.sqlMigrationServiceName = value
    }

    /**
     * @param value
     */
    @JvmName("miwxrqqdwmjokhfs")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value
     */
    @JvmName("qiwmufsxvdgjwhqb")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("dvqblxgqirwfpgvu")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the SQL Migration Service.
     */
    @JvmName("kvlygisykxiywtik")
    public suspend fun sqlMigrationServiceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sqlMigrationServiceName = mapped
    }

    /**
     * @param value
     */
    @JvmName("rxnjogqonikodefk")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values
     */
    @JvmName("vjumiyrnsooyttby")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): SqlMigrationServiceArgs = SqlMigrationServiceArgs(
        location = location,
        resourceGroupName = resourceGroupName,
        sqlMigrationServiceName = sqlMigrationServiceName,
        tags = tags,
    )
}
