@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin

import com.pulumi.azurenative.datamigration.TaskArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A task resource
 * Azure REST API version: 2021-06-30. Prior API version in Azure Native 1.x: 2018-04-19.
 * Other available API versions: 2022-03-30-preview, 2023-07-15-preview.
 * ## Example Usage
 * ### Tasks_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var task = new AzureNative.DataMigration.Task("task", new()
 *     {
 *         GroupName = "DmsSdkRg",
 *         ProjectName = "DmsSdkProject",
 *         Properties = new AzureNative.DataMigration.Inputs.ConnectToTargetSqlDbTaskPropertiesArgs
 *         {
 *             Input = new AzureNative.DataMigration.Inputs.ConnectToTargetSqlDbTaskInputArgs
 *             {
 *                 TargetConnectionInfo = new AzureNative.DataMigration.Inputs.SqlConnectionInfoArgs
 *                 {
 *                     Authentication = AzureNative.DataMigration.AuthenticationType.SqlAuthentication,
 *                     DataSource = "ssma-test-server.database.windows.net",
 *                     EncryptConnection = true,
 *                     Password = "testpassword",
 *                     TrustServerCertificate = true,
 *                     Type = "SqlConnectionInfo",
 *                     UserName = "testuser",
 *                 },
 *             },
 *             TaskType = "ConnectToTarget.SqlDb",
 *         },
 *         ServiceName = "DmsSdkService",
 *         TaskName = "DmsSdkTask",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datamigration/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datamigration.NewTask(ctx, "task", &datamigration.TaskArgs{
 * 			GroupName:   pulumi.String("DmsSdkRg"),
 * 			ProjectName: pulumi.String("DmsSdkProject"),
 * 			Properties: datamigration.ConnectToTargetSqlDbTaskProperties{
 * 				Input: datamigration.ConnectToTargetSqlDbTaskInput{
 * 					TargetConnectionInfo: datamigration.SqlConnectionInfo{
 * 						Authentication:         datamigration.AuthenticationTypeSqlAuthentication,
 * 						DataSource:             "ssma-test-server.database.windows.net",
 * 						EncryptConnection:      true,
 * 						Password:               "testpassword",
 * 						TrustServerCertificate: true,
 * 						Type:                   "SqlConnectionInfo",
 * 						UserName:               "testuser",
 * 					},
 * 				},
 * 				TaskType: "ConnectToTarget.SqlDb",
 * 			},
 * 			ServiceName: pulumi.String("DmsSdkService"),
 * 			TaskName:    pulumi.String("DmsSdkTask"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datamigration.Task;
 * import com.pulumi.azurenative.datamigration.TaskArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var task = new Task("task", TaskArgs.builder()
 *             .groupName("DmsSdkRg")
 *             .projectName("DmsSdkProject")
 *             .properties(ConnectToMongoDbTaskPropertiesArgs.builder()
 *                 .input(MongoDbConnectionInfoArgs.builder()
 *                     .targetConnectionInfo(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *                     .build())
 *                 .taskType("ConnectToTarget.SqlDb")
 *                 .build())
 *             .serviceName("DmsSdkService")
 *             .taskName("DmsSdkTask")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:datamigration:Task DmsSdkTask /subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.DataMigration/services/{serviceName}/projects/{projectName}/tasks/{taskName}
 * ```
 * @property groupName Name of the resource group
 * @property projectName Name of the project
 * @property properties Custom task properties
 * @property serviceName Name of the service
 * @property taskName Name of the Task
 */
public data class TaskArgs(
    public val groupName: Output<String>? = null,
    public val projectName: Output<String>? = null,
    public val properties: Output<Any>? = null,
    public val serviceName: Output<String>? = null,
    public val taskName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datamigration.TaskArgs> {
    override fun toJava(): com.pulumi.azurenative.datamigration.TaskArgs =
        com.pulumi.azurenative.datamigration.TaskArgs.builder()
            .groupName(groupName?.applyValue({ args0 -> args0 }))
            .projectName(projectName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 }))
            .taskName(taskName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TaskArgs].
 */
@PulumiTagMarker
public class TaskArgsBuilder internal constructor() {
    private var groupName: Output<String>? = null

    private var projectName: Output<String>? = null

    private var properties: Output<Any>? = null

    private var serviceName: Output<String>? = null

    private var taskName: Output<String>? = null

    /**
     * @param value Name of the resource group
     */
    @JvmName("njjjfeiqlhhfncsb")
    public suspend fun groupName(`value`: Output<String>) {
        this.groupName = value
    }

    /**
     * @param value Name of the project
     */
    @JvmName("vesuluqywkqiewhr")
    public suspend fun projectName(`value`: Output<String>) {
        this.projectName = value
    }

    /**
     * @param value Custom task properties
     */
    @JvmName("tylvbhvjmxytmpul")
    public suspend fun properties(`value`: Output<Any>) {
        this.properties = value
    }

    /**
     * @param value Name of the service
     */
    @JvmName("cnehectujambjspt")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value Name of the Task
     */
    @JvmName("hsrpphfjtddpgmgk")
    public suspend fun taskName(`value`: Output<String>) {
        this.taskName = value
    }

    /**
     * @param value Name of the resource group
     */
    @JvmName("bvksajixcjlapene")
    public suspend fun groupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupName = mapped
    }

    /**
     * @param value Name of the project
     */
    @JvmName("odyqvsfnpmrifedo")
    public suspend fun projectName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.projectName = mapped
    }

    /**
     * @param value Custom task properties
     */
    @JvmName("elhcdbhgjpphglhc")
    public suspend fun properties(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value Name of the service
     */
    @JvmName("hjkuthjjueeauxkv")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    /**
     * @param value Name of the Task
     */
    @JvmName("axoacpwwpgayegko")
    public suspend fun taskName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.taskName = mapped
    }

    internal fun build(): TaskArgs = TaskArgs(
        groupName = groupName,
        projectName = projectName,
        properties = properties,
        serviceName = serviceName,
        taskName = taskName,
    )
}
