@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Authentication type to use for connection
 */
public enum class AuthenticationType(
    public val javaValue: com.pulumi.azurenative.datamigration.enums.AuthenticationType,
) : ConvertibleToJava<com.pulumi.azurenative.datamigration.enums.AuthenticationType> {
    None(com.pulumi.azurenative.datamigration.enums.AuthenticationType.None),
    WindowsAuthentication(com.pulumi.azurenative.datamigration.enums.AuthenticationType.WindowsAuthentication),
    SqlAuthentication(com.pulumi.azurenative.datamigration.enums.AuthenticationType.SqlAuthentication),
    ActiveDirectoryIntegrated(com.pulumi.azurenative.datamigration.enums.AuthenticationType.ActiveDirectoryIntegrated),
    ActiveDirectoryPassword(com.pulumi.azurenative.datamigration.enums.AuthenticationType.ActiveDirectoryPassword),
    ;

    override fun toJava(): com.pulumi.azurenative.datamigration.enums.AuthenticationType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datamigration.enums.AuthenticationType): AuthenticationType = AuthenticationType.values().first { it.javaValue == javaType }
    }
}
