@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The SSIS store type of source, only SSIS catalog is supported now in DMS
 */
public enum class SsisStoreType(
    public val javaValue: com.pulumi.azurenative.datamigration.enums.SsisStoreType,
) : ConvertibleToJava<com.pulumi.azurenative.datamigration.enums.SsisStoreType> {
    SsisCatalog(com.pulumi.azurenative.datamigration.enums.SsisStoreType.SsisCatalog),
    ;

    override fun toJava(): com.pulumi.azurenative.datamigration.enums.SsisStoreType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datamigration.enums.SsisStoreType): SsisStoreType = SsisStoreType.values().first { it.javaValue == javaType }
    }
}
