@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.inputs

import com.pulumi.azurenative.datamigration.inputs.BlobShareArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Blob container storage information.
 * @property sasUri SAS URI of Azure Storage Account Container.
 */
public data class BlobShareArgs(
    public val sasUri: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datamigration.inputs.BlobShareArgs> {
    override fun toJava(): com.pulumi.azurenative.datamigration.inputs.BlobShareArgs =
        com.pulumi.azurenative.datamigration.inputs.BlobShareArgs.builder()
            .sasUri(sasUri.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BlobShareArgs].
 */
@PulumiTagMarker
public class BlobShareArgsBuilder internal constructor() {
    private var sasUri: Output<String>? = null

    /**
     * @param value SAS URI of Azure Storage Account Container.
     */
    @JvmName("whspdbhgytdhwrbp")
    public suspend fun sasUri(`value`: Output<String>) {
        this.sasUri = value
    }

    /**
     * @param value SAS URI of Azure Storage Account Container.
     */
    @JvmName("wrmxcswfjpiotnnw")
    public suspend fun sasUri(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sasUri = mapped
    }

    internal fun build(): BlobShareArgs = BlobShareArgs(
        sasUri = sasUri ?: throw PulumiNullFieldException("sasUri"),
    )
}
