@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.inputs

import com.pulumi.azurenative.datamigration.inputs.FileShareArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * File share information with Path, Username, and Password.
 * @property password Password credential used to connect to the share location.
 * @property path The folder path for this share.
 * @property userName User name credential to connect to the share location
 */
public data class FileShareArgs(
    public val password: Output<String>? = null,
    public val path: Output<String>,
    public val userName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datamigration.inputs.FileShareArgs> {
    override fun toJava(): com.pulumi.azurenative.datamigration.inputs.FileShareArgs =
        com.pulumi.azurenative.datamigration.inputs.FileShareArgs.builder()
            .password(password?.applyValue({ args0 -> args0 }))
            .path(path.applyValue({ args0 -> args0 }))
            .userName(userName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FileShareArgs].
 */
@PulumiTagMarker
public class FileShareArgsBuilder internal constructor() {
    private var password: Output<String>? = null

    private var path: Output<String>? = null

    private var userName: Output<String>? = null

    /**
     * @param value Password credential used to connect to the share location.
     */
    @JvmName("uqxrlbtqwkxitaar")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value The folder path for this share.
     */
    @JvmName("ibokvevvjotgkdkf")
    public suspend fun path(`value`: Output<String>) {
        this.path = value
    }

    /**
     * @param value User name credential to connect to the share location
     */
    @JvmName("ebwlatfnpsgxhlnl")
    public suspend fun userName(`value`: Output<String>) {
        this.userName = value
    }

    /**
     * @param value Password credential used to connect to the share location.
     */
    @JvmName("vmkgcmfyntdfymsq")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value The folder path for this share.
     */
    @JvmName("vmmhevefxkppcjol")
    public suspend fun path(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.path = mapped
    }

    /**
     * @param value User name credential to connect to the share location
     */
    @JvmName("egochevqwxjrxmjn")
    public suspend fun userName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userName = mapped
    }

    internal fun build(): FileShareArgs = FileShareArgs(
        password = password,
        path = path ?: throw PulumiNullFieldException("path"),
        userName = userName,
    )
}
