@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.inputs

import com.pulumi.azurenative.datamigration.inputs.GetUserTablesPostgreSqlTaskInputArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Input for the task that gets the list of tables for a provided list of PostgreSQL databases.
 * @property connectionInfo Information for connecting to PostgreSQL source
 * @property selectedDatabases List of PostgreSQL databases for which to collect tables
 */
public data class GetUserTablesPostgreSqlTaskInputArgs(
    public val connectionInfo: Output<PostgreSqlConnectionInfoArgs>,
    public val selectedDatabases: Output<List<String>>,
) :
    ConvertibleToJava<com.pulumi.azurenative.datamigration.inputs.GetUserTablesPostgreSqlTaskInputArgs> {
    override fun toJava(): com.pulumi.azurenative.datamigration.inputs.GetUserTablesPostgreSqlTaskInputArgs =
        com.pulumi.azurenative.datamigration.inputs.GetUserTablesPostgreSqlTaskInputArgs.builder()
            .connectionInfo(connectionInfo.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .selectedDatabases(selectedDatabases.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [GetUserTablesPostgreSqlTaskInputArgs].
 */
@PulumiTagMarker
public class GetUserTablesPostgreSqlTaskInputArgsBuilder internal constructor() {
    private var connectionInfo: Output<PostgreSqlConnectionInfoArgs>? = null

    private var selectedDatabases: Output<List<String>>? = null

    /**
     * @param value Information for connecting to PostgreSQL source
     */
    @JvmName("njvcfwjiptkmkmno")
    public suspend fun connectionInfo(`value`: Output<PostgreSqlConnectionInfoArgs>) {
        this.connectionInfo = value
    }

    /**
     * @param value List of PostgreSQL databases for which to collect tables
     */
    @JvmName("sdkmxaiwcygnlxbi")
    public suspend fun selectedDatabases(`value`: Output<List<String>>) {
        this.selectedDatabases = value
    }

    @JvmName("jhfcwkisaphothsf")
    public suspend fun selectedDatabases(vararg values: Output<String>) {
        this.selectedDatabases = Output.all(values.asList())
    }

    /**
     * @param values List of PostgreSQL databases for which to collect tables
     */
    @JvmName("rpjsmuynmudpcgcf")
    public suspend fun selectedDatabases(values: List<Output<String>>) {
        this.selectedDatabases = Output.all(values)
    }

    /**
     * @param value Information for connecting to PostgreSQL source
     */
    @JvmName("oauqsinwesmvifjr")
    public suspend fun connectionInfo(`value`: PostgreSqlConnectionInfoArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.connectionInfo = mapped
    }

    /**
     * @param argument Information for connecting to PostgreSQL source
     */
    @JvmName("vrdoweufrkphtdjk")
    public suspend fun connectionInfo(argument: suspend PostgreSqlConnectionInfoArgsBuilder.() -> Unit) {
        val toBeMapped = PostgreSqlConnectionInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.connectionInfo = mapped
    }

    /**
     * @param value List of PostgreSQL databases for which to collect tables
     */
    @JvmName("dnematrweuoajnvr")
    public suspend fun selectedDatabases(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.selectedDatabases = mapped
    }

    /**
     * @param values List of PostgreSQL databases for which to collect tables
     */
    @JvmName("cmjwvrdbdlqqsckg")
    public suspend fun selectedDatabases(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.selectedDatabases = mapped
    }

    internal fun build(): GetUserTablesPostgreSqlTaskInputArgs = GetUserTablesPostgreSqlTaskInputArgs(
        connectionInfo = connectionInfo ?: throw PulumiNullFieldException("connectionInfo"),
        selectedDatabases = selectedDatabases ?: throw PulumiNullFieldException("selectedDatabases"),
    )
}
