@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.inputs

import com.pulumi.azurenative.datamigration.inputs.MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseInputArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Database specific information for PostgreSQL to Azure Database for PostgreSQL migration task inputs
 * @property migrationSetting Migration settings which tune the migration behavior
 * @property name Name of the database
 * @property selectedTables Tables selected for migration
 * @property sourceSetting Source settings to tune source endpoint migration behavior
 * @property targetDatabaseName Name of target database. Note: Target database will be truncated before starting migration.
 * @property targetSetting Target settings to tune target endpoint migration behavior
 */
public data class MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseInputArgs(
    public val migrationSetting: Output<Map<String, String>>? = null,
    public val name: Output<String>? = null,
    public val selectedTables: Output<List<MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseTableInputArgs>>? = null,
    public val sourceSetting: Output<Map<String, String>>? = null,
    public val targetDatabaseName: Output<String>? = null,
    public val targetSetting: Output<Map<String, String>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.datamigration.inputs.MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseInputArgs> {
    override fun toJava(): com.pulumi.azurenative.datamigration.inputs.MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseInputArgs =
        com.pulumi.azurenative.datamigration.inputs.MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseInputArgs.builder()
            .migrationSetting(
                migrationSetting?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .selectedTables(
                selectedTables?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .sourceSetting(
                sourceSetting?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .targetDatabaseName(targetDatabaseName?.applyValue({ args0 -> args0 }))
            .targetSetting(
                targetSetting?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseInputArgs].
 */
@PulumiTagMarker
public class MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseInputArgsBuilder internal constructor() {
    private var migrationSetting: Output<Map<String, String>>? = null

    private var name: Output<String>? = null

    private var selectedTables:
        Output<List<MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseTableInputArgs>>? = null

    private var sourceSetting: Output<Map<String, String>>? = null

    private var targetDatabaseName: Output<String>? = null

    private var targetSetting: Output<Map<String, String>>? = null

    /**
     * @param value Migration settings which tune the migration behavior
     */
    @JvmName("yyhrqnbrlscwkkbv")
    public suspend fun migrationSetting(`value`: Output<Map<String, String>>) {
        this.migrationSetting = value
    }

    /**
     * @param value Name of the database
     */
    @JvmName("sxdjoathmadraisb")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Tables selected for migration
     */
    @JvmName("wmobwxmfidcmqfhg")
    public suspend fun selectedTables(`value`: Output<List<MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseTableInputArgs>>) {
        this.selectedTables = value
    }

    @JvmName("mupnvnuexyoaxnkp")
    public suspend fun selectedTables(vararg values: Output<MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseTableInputArgs>) {
        this.selectedTables = Output.all(values.asList())
    }

    /**
     * @param values Tables selected for migration
     */
    @JvmName("pckkblgkvnbftgqa")
    public suspend fun selectedTables(values: List<Output<MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseTableInputArgs>>) {
        this.selectedTables = Output.all(values)
    }

    /**
     * @param value Source settings to tune source endpoint migration behavior
     */
    @JvmName("vgkbjjngnoislxye")
    public suspend fun sourceSetting(`value`: Output<Map<String, String>>) {
        this.sourceSetting = value
    }

    /**
     * @param value Name of target database. Note: Target database will be truncated before starting migration.
     */
    @JvmName("bxeseltsghivxsmc")
    public suspend fun targetDatabaseName(`value`: Output<String>) {
        this.targetDatabaseName = value
    }

    /**
     * @param value Target settings to tune target endpoint migration behavior
     */
    @JvmName("rqpxmntwhpephfwv")
    public suspend fun targetSetting(`value`: Output<Map<String, String>>) {
        this.targetSetting = value
    }

    /**
     * @param value Migration settings which tune the migration behavior
     */
    @JvmName("revypjhrjatphpge")
    public suspend fun migrationSetting(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.migrationSetting = mapped
    }

    /**
     * @param values Migration settings which tune the migration behavior
     */
    @JvmName("vcakjkuosmsefmos")
    public fun migrationSetting(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.migrationSetting = mapped
    }

    /**
     * @param value Name of the database
     */
    @JvmName("gqseobvwfyaynpek")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Tables selected for migration
     */
    @JvmName("ykynojwuyavxfxtx")
    public suspend fun selectedTables(`value`: List<MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseTableInputArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.selectedTables = mapped
    }

    /**
     * @param argument Tables selected for migration
     */
    @JvmName("xrfqjmoxygpebnnw")
    public suspend fun selectedTables(argument: List<suspend MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseTableInputArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseTableInputArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.selectedTables = mapped
    }

    /**
     * @param argument Tables selected for migration
     */
    @JvmName("wnsbufbjpesslssw")
    public suspend fun selectedTables(vararg argument: suspend MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseTableInputArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseTableInputArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.selectedTables = mapped
    }

    /**
     * @param argument Tables selected for migration
     */
    @JvmName("eadikkacnyrbscwg")
    public suspend fun selectedTables(argument: suspend MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseTableInputArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseTableInputArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.selectedTables = mapped
    }

    /**
     * @param values Tables selected for migration
     */
    @JvmName("chgtswsfmkirirbt")
    public suspend fun selectedTables(vararg values: MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseTableInputArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.selectedTables = mapped
    }

    /**
     * @param value Source settings to tune source endpoint migration behavior
     */
    @JvmName("ujxhvxuxscgpvrqc")
    public suspend fun sourceSetting(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceSetting = mapped
    }

    /**
     * @param values Source settings to tune source endpoint migration behavior
     */
    @JvmName("besdgshvanaqsyvs")
    public fun sourceSetting(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceSetting = mapped
    }

    /**
     * @param value Name of target database. Note: Target database will be truncated before starting migration.
     */
    @JvmName("bxrjdwtixnwsapka")
    public suspend fun targetDatabaseName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetDatabaseName = mapped
    }

    /**
     * @param value Target settings to tune target endpoint migration behavior
     */
    @JvmName("vvuuhemllpraysab")
    public suspend fun targetSetting(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetSetting = mapped
    }

    /**
     * @param values Target settings to tune target endpoint migration behavior
     */
    @JvmName("bxyijeiqyvilymxa")
    public fun targetSetting(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetSetting = mapped
    }

    internal fun build(): MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseInputArgs =
        MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseInputArgs(
            migrationSetting = migrationSetting,
            name = name,
            selectedTables = selectedTables,
            sourceSetting = sourceSetting,
            targetDatabaseName = targetDatabaseName,
            targetSetting = targetSetting,
        )
}
