@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.inputs

import com.pulumi.azurenative.datamigration.inputs.MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseTableInputArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Selected tables for the migration
 * @property name Name of the table to migrate
 */
public data class MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseTableInputArgs(
    public val name: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.datamigration.inputs.MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseTableInputArgs> {
    override fun toJava(): com.pulumi.azurenative.datamigration.inputs.MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseTableInputArgs =
        com.pulumi.azurenative.datamigration.inputs.MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseTableInputArgs.builder()
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseTableInputArgs].
 */
@PulumiTagMarker
public class MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseTableInputArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    /**
     * @param value Name of the table to migrate
     */
    @JvmName("yhmelirtlytamqwr")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Name of the table to migrate
     */
    @JvmName("cbmblammvmkoujit")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseTableInputArgs =
        MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseTableInputArgs(
            name = name,
        )
}
