@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.inputs

import com.pulumi.azurenative.datamigration.inputs.MongoDbConnectionInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes a connection to a MongoDB data source
 * @property connectionString A MongoDB connection string or blob container URL. The user name and password can be specified here or in the userName and password properties
 * @property password Password credential.
 * @property type Type of connection info
 * Expected value is 'MongoDbConnectionInfo'.
 * @property userName User name
 */
public data class MongoDbConnectionInfoArgs(
    public val connectionString: Output<String>,
    public val password: Output<String>? = null,
    public val type: Output<String>,
    public val userName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datamigration.inputs.MongoDbConnectionInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.datamigration.inputs.MongoDbConnectionInfoArgs =
        com.pulumi.azurenative.datamigration.inputs.MongoDbConnectionInfoArgs.builder()
            .connectionString(connectionString.applyValue({ args0 -> args0 }))
            .password(password?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .userName(userName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MongoDbConnectionInfoArgs].
 */
@PulumiTagMarker
public class MongoDbConnectionInfoArgsBuilder internal constructor() {
    private var connectionString: Output<String>? = null

    private var password: Output<String>? = null

    private var type: Output<String>? = null

    private var userName: Output<String>? = null

    /**
     * @param value A MongoDB connection string or blob container URL. The user name and password can be specified here or in the userName and password properties
     */
    @JvmName("wjgtllishoedjkyy")
    public suspend fun connectionString(`value`: Output<String>) {
        this.connectionString = value
    }

    /**
     * @param value Password credential.
     */
    @JvmName("cuuxfuepwnxkmohh")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value Type of connection info
     * Expected value is 'MongoDbConnectionInfo'.
     */
    @JvmName("kjbmsivipsxodnkr")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value User name
     */
    @JvmName("klymwjlwuuufdfyx")
    public suspend fun userName(`value`: Output<String>) {
        this.userName = value
    }

    /**
     * @param value A MongoDB connection string or blob container URL. The user name and password can be specified here or in the userName and password properties
     */
    @JvmName("fxupbrelpuchqcpa")
    public suspend fun connectionString(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.connectionString = mapped
    }

    /**
     * @param value Password credential.
     */
    @JvmName("kffbconvbylisvgo")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value Type of connection info
     * Expected value is 'MongoDbConnectionInfo'.
     */
    @JvmName("fmpdcuybbcathabk")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value User name
     */
    @JvmName("nlmhffyvfumqedxd")
    public suspend fun userName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userName = mapped
    }

    internal fun build(): MongoDbConnectionInfoArgs = MongoDbConnectionInfoArgs(
        connectionString = connectionString ?: throw PulumiNullFieldException("connectionString"),
        password = password,
        type = type ?: throw PulumiNullFieldException("type"),
        userName = userName,
    )
}
