@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.inputs

import com.pulumi.azurenative.datamigration.inputs.MongoDbShardKeyFieldArgs.builder
import com.pulumi.azurenative.datamigration.kotlin.enums.MongoDbShardKeyOrder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes a field reference within a MongoDB shard key
 * @property name The name of the field
 * @property order The field ordering
 */
public data class MongoDbShardKeyFieldArgs(
    public val name: Output<String>,
    public val order: Output<Either<String, MongoDbShardKeyOrder>>,
) : ConvertibleToJava<com.pulumi.azurenative.datamigration.inputs.MongoDbShardKeyFieldArgs> {
    override fun toJava(): com.pulumi.azurenative.datamigration.inputs.MongoDbShardKeyFieldArgs =
        com.pulumi.azurenative.datamigration.inputs.MongoDbShardKeyFieldArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .order(
                order.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [MongoDbShardKeyFieldArgs].
 */
@PulumiTagMarker
public class MongoDbShardKeyFieldArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var order: Output<Either<String, MongoDbShardKeyOrder>>? = null

    /**
     * @param value The name of the field
     */
    @JvmName("nsaruqtntkrfpkbg")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The field ordering
     */
    @JvmName("irmnfihujcbemtro")
    public suspend fun order(`value`: Output<Either<String, MongoDbShardKeyOrder>>) {
        this.order = value
    }

    /**
     * @param value The name of the field
     */
    @JvmName("qbvfgcdpxhxueolm")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The field ordering
     */
    @JvmName("ysumqflroopletqr")
    public suspend fun order(`value`: Either<String, MongoDbShardKeyOrder>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.order = mapped
    }

    /**
     * @param value The field ordering
     */
    @JvmName("khounbddtuibxrqr")
    public fun order(`value`: String) {
        val toBeMapped = Either.ofLeft<String, MongoDbShardKeyOrder>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.order = mapped
    }

    /**
     * @param value The field ordering
     */
    @JvmName("enpiphjwpliiqqyr")
    public fun order(`value`: MongoDbShardKeyOrder) {
        val toBeMapped = Either.ofRight<String, MongoDbShardKeyOrder>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.order = mapped
    }

    internal fun build(): MongoDbShardKeyFieldArgs = MongoDbShardKeyFieldArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        order = order ?: throw PulumiNullFieldException("order"),
    )
}
