@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.inputs

import com.pulumi.azurenative.datamigration.inputs.MongoMigrationCollectionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Mongo source and target database and collection details.
 * @property sourceCollection Source collection name.
 * @property sourceDatabase Source database name.
 * @property targetCollection Target collection name.
 * @property targetDatabase Target database name.
 */
public data class MongoMigrationCollectionArgs(
    public val sourceCollection: Output<String>? = null,
    public val sourceDatabase: Output<String>? = null,
    public val targetCollection: Output<String>? = null,
    public val targetDatabase: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datamigration.inputs.MongoMigrationCollectionArgs> {
    override fun toJava(): com.pulumi.azurenative.datamigration.inputs.MongoMigrationCollectionArgs =
        com.pulumi.azurenative.datamigration.inputs.MongoMigrationCollectionArgs.builder()
            .sourceCollection(sourceCollection?.applyValue({ args0 -> args0 }))
            .sourceDatabase(sourceDatabase?.applyValue({ args0 -> args0 }))
            .targetCollection(targetCollection?.applyValue({ args0 -> args0 }))
            .targetDatabase(targetDatabase?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MongoMigrationCollectionArgs].
 */
@PulumiTagMarker
public class MongoMigrationCollectionArgsBuilder internal constructor() {
    private var sourceCollection: Output<String>? = null

    private var sourceDatabase: Output<String>? = null

    private var targetCollection: Output<String>? = null

    private var targetDatabase: Output<String>? = null

    /**
     * @param value Source collection name.
     */
    @JvmName("xteourcgdqeaxiob")
    public suspend fun sourceCollection(`value`: Output<String>) {
        this.sourceCollection = value
    }

    /**
     * @param value Source database name.
     */
    @JvmName("lrvvinabvvcroive")
    public suspend fun sourceDatabase(`value`: Output<String>) {
        this.sourceDatabase = value
    }

    /**
     * @param value Target collection name.
     */
    @JvmName("lntaegdccdkdtinb")
    public suspend fun targetCollection(`value`: Output<String>) {
        this.targetCollection = value
    }

    /**
     * @param value Target database name.
     */
    @JvmName("nfcaiuuvemgcvonw")
    public suspend fun targetDatabase(`value`: Output<String>) {
        this.targetDatabase = value
    }

    /**
     * @param value Source collection name.
     */
    @JvmName("sjwdpsmtwioyspia")
    public suspend fun sourceCollection(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceCollection = mapped
    }

    /**
     * @param value Source database name.
     */
    @JvmName("lqicbycjljwtalee")
    public suspend fun sourceDatabase(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceDatabase = mapped
    }

    /**
     * @param value Target collection name.
     */
    @JvmName("desjqqptijsnsaoc")
    public suspend fun targetCollection(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetCollection = mapped
    }

    /**
     * @param value Target database name.
     */
    @JvmName("fanksinrofxlbhay")
    public suspend fun targetDatabase(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetDatabase = mapped
    }

    internal fun build(): MongoMigrationCollectionArgs = MongoMigrationCollectionArgs(
        sourceCollection = sourceCollection,
        sourceDatabase = sourceDatabase,
        targetCollection = targetCollection,
        targetDatabase = targetDatabase,
    )
}
