@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.inputs

import com.pulumi.azurenative.datamigration.inputs.OracleConnectionInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Information for connecting to Oracle server
 * @property dataSource EZConnect or TNSName connection string.
 * @property password Password credential.
 * @property type Type of connection info
 * Expected value is 'OracleConnectionInfo'.
 * @property userName User name
 */
public data class OracleConnectionInfoArgs(
    public val dataSource: Output<String>,
    public val password: Output<String>? = null,
    public val type: Output<String>,
    public val userName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datamigration.inputs.OracleConnectionInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.datamigration.inputs.OracleConnectionInfoArgs =
        com.pulumi.azurenative.datamigration.inputs.OracleConnectionInfoArgs.builder()
            .dataSource(dataSource.applyValue({ args0 -> args0 }))
            .password(password?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .userName(userName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OracleConnectionInfoArgs].
 */
@PulumiTagMarker
public class OracleConnectionInfoArgsBuilder internal constructor() {
    private var dataSource: Output<String>? = null

    private var password: Output<String>? = null

    private var type: Output<String>? = null

    private var userName: Output<String>? = null

    /**
     * @param value EZConnect or TNSName connection string.
     */
    @JvmName("jmqcwrjcfhgwofph")
    public suspend fun dataSource(`value`: Output<String>) {
        this.dataSource = value
    }

    /**
     * @param value Password credential.
     */
    @JvmName("ocghlnmbamobyjhx")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value Type of connection info
     * Expected value is 'OracleConnectionInfo'.
     */
    @JvmName("wuarmohwtkaybmip")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value User name
     */
    @JvmName("frjwwcajgfiineco")
    public suspend fun userName(`value`: Output<String>) {
        this.userName = value
    }

    /**
     * @param value EZConnect or TNSName connection string.
     */
    @JvmName("wlimteqkpoewcmyl")
    public suspend fun dataSource(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataSource = mapped
    }

    /**
     * @param value Password credential.
     */
    @JvmName("fjcbhbwnynlcsahl")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value Type of connection info
     * Expected value is 'OracleConnectionInfo'.
     */
    @JvmName("ppgsjmdpdrpjqcrn")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value User name
     */
    @JvmName("kekunccwcrdxrste")
    public suspend fun userName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userName = mapped
    }

    internal fun build(): OracleConnectionInfoArgs = OracleConnectionInfoArgs(
        dataSource = dataSource ?: throw PulumiNullFieldException("dataSource"),
        password = password,
        type = type ?: throw PulumiNullFieldException("type"),
        userName = userName,
    )
}
