@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Azure Active Directory Application
 * @property appKey Key used to authenticate to the Azure Active Directory Application
 * @property applicationId Application ID of the Azure Active Directory Application
 * @property tenantId Tenant id of the customer
 */
public data class AzureActiveDirectoryAppResponse(
    public val appKey: String,
    public val applicationId: String,
    public val tenantId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.AzureActiveDirectoryAppResponse): AzureActiveDirectoryAppResponse = AzureActiveDirectoryAppResponse(
            appKey = javaType.appKey(),
            applicationId = javaType.applicationId(),
            tenantId = javaType.tenantId(),
        )
    }
}
