@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Information of the backup file
 * @property familySequenceNumber Sequence number of the backup file in the backup set
 * @property fileLocation Location of the backup file in shared folder
 * @property status Status of the backup file during migration
 */
public data class BackupFileInfoResponse(
    public val familySequenceNumber: Int? = null,
    public val fileLocation: String? = null,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.BackupFileInfoResponse): BackupFileInfoResponse = BackupFileInfoResponse(
            familySequenceNumber = javaType.familySequenceNumber().map({ args0 -> args0 }).orElse(null),
            fileLocation = javaType.fileLocation().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
