@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Blob container storage information.
 * @property sasUri SAS URI of Azure Storage Account Container.
 */
public data class BlobShareResponse(
    public val sasUri: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.BlobShareResponse): BlobShareResponse = BlobShareResponse(
            sasUri = javaType.sasUri(),
        )
    }
}
