@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import com.pulumi.core.Either
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Properties for the task that validates the connection to and provides information about a MongoDB server
 * @property clientData Key value pairs of client data to attach meta data information to task
 * @property commands Array of command properties.
 * @property errors Array of errors. This is ignored if submitted.
 * @property input Describes a connection to a MongoDB data source
 * @property output An array containing a single MongoDbClusterInfo object
 * @property state The state of the task. This is ignored if submitted.
 * @property taskType Task type.
 * Expected value is 'Connect.MongoDb'.
 */
public data class ConnectToMongoDbTaskPropertiesResponse(
    public val clientData: Map<String, String>? = null,
    public val commands: List<Either<MigrateMISyncCompleteCommandPropertiesResponse, MigrateSyncCompleteCommandPropertiesResponse>>,
    public val errors: List<ODataErrorResponse>,
    public val input: MongoDbConnectionInfoResponse? = null,
    public val output: List<MongoDbClusterInfoResponse>,
    public val state: String,
    public val taskType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.ConnectToMongoDbTaskPropertiesResponse): ConnectToMongoDbTaskPropertiesResponse = ConnectToMongoDbTaskPropertiesResponse(
            clientData = javaType.clientData().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            commands = javaType.commands().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datamigration.kotlin.outputs.MigrateMISyncCompleteCommandPropertiesResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datamigration.kotlin.outputs.MigrateSyncCompleteCommandPropertiesResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }),
            errors = javaType.errors().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datamigration.kotlin.outputs.ODataErrorResponse.Companion.toKotlin(args0)
                })
            }),
            input = javaType.input().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datamigration.kotlin.outputs.MongoDbConnectionInfoResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            output = javaType.output().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datamigration.kotlin.outputs.MongoDbClusterInfoResponse.Companion.toKotlin(args0)
                })
            }),
            state = javaType.state(),
            taskType = javaType.taskType(),
        )
    }
}
