@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Input for the task that validates MySQL database connection
 * @property checkPermissionsGroup Permission group for validations
 * @property isOfflineMigration Flag for whether or not the migration is offline
 * @property sourceConnectionInfo Information for connecting to MySQL source
 * @property targetPlatform Target Platform for the migration
 */
public data class ConnectToSourceMySqlTaskInputResponse(
    public val checkPermissionsGroup: String? = null,
    public val isOfflineMigration: Boolean? = null,
    public val sourceConnectionInfo: MySqlConnectionInfoResponse,
    public val targetPlatform: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.ConnectToSourceMySqlTaskInputResponse): ConnectToSourceMySqlTaskInputResponse = ConnectToSourceMySqlTaskInputResponse(
            checkPermissionsGroup = javaType.checkPermissionsGroup().map({ args0 -> args0 }).orElse(null),
            isOfflineMigration = javaType.isOfflineMigration().map({ args0 -> args0 }).orElse(null),
            sourceConnectionInfo = javaType.sourceConnectionInfo().let({ args0 ->
                com.pulumi.azurenative.datamigration.kotlin.outputs.MySqlConnectionInfoResponse.Companion.toKotlin(args0)
            }),
            targetPlatform = javaType.targetPlatform().map({ args0 -> args0 }).orElse(null),
        )
    }
}
