@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.Suppress

/**
 * Input for the task that validates Oracle database connection
 * @property sourceConnectionInfo Information for connecting to Oracle source
 */
public data class ConnectToSourceOracleSyncTaskInputResponse(
    public val sourceConnectionInfo: OracleConnectionInfoResponse,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.ConnectToSourceOracleSyncTaskInputResponse): ConnectToSourceOracleSyncTaskInputResponse = ConnectToSourceOracleSyncTaskInputResponse(
            sourceConnectionInfo = javaType.sourceConnectionInfo().let({ args0 ->
                com.pulumi.azurenative.datamigration.kotlin.outputs.OracleConnectionInfoResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
